/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.support.tone;

import com.taotao.cloud.common.support.handler.IHandler;
import com.taotao.cloud.common.utils.collection.CollectionUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.pinyin.api.IPinyinContext;
import com.taotao.cloud.pinyin.spi.IPinyinTone;
import com.taotao.cloud.pinyin.spi.IPinyinToneStyle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPinyinTone
implements IPinyinTone {
    protected abstract String getCharTone(String var1, IPinyinToneStyle var2);

    protected abstract List<String> getCharTones(String var1, IPinyinToneStyle var2);

    protected abstract String getPhraseTone(String var1, IPinyinToneStyle var2, String var3);

    @Override
    public String tone(String segment, IPinyinContext context) {
        String result;
        int length = segment.length();
        final IPinyinToneStyle toneStyle = context.style();
        String connector = context.connector();
        if (length == 1) {
            this.getCharToneDefault(segment, toneStyle);
        }
        if (StringUtils.isNotEmpty((CharSequence)(result = this.getPhraseTone(segment, toneStyle, connector)))) {
            return result;
        }
        List chars = StringUtils.toCharStringList((String)segment);
        List tones = CollectionUtils.toList((Iterable)chars, (IHandler)new IHandler<String, String>(){

            public String handle(String string) {
                return AbstractPinyinTone.this.getCharToneDefault(string, toneStyle);
            }
        });
        return StringUtils.join((Collection)tones, (String)" ");
    }

    private String getCharToneDefault(String string, IPinyinToneStyle toneStyle) {
        String pinyin = this.getCharTone(string, toneStyle);
        if (StringUtils.isNotEmpty((CharSequence)pinyin)) {
            return pinyin;
        }
        return string;
    }

    @Override
    public List<String> toneList(String chinese, IPinyinContext context) {
        IPinyinToneStyle toneStyle = context.style();
        return this.getCharTonesDefault(chinese, toneStyle);
    }

    private List<String> getCharTonesDefault(String chinese, IPinyinToneStyle toneStyle) {
        List<String> toneList = this.getCharTones(chinese, toneStyle);
        if (CollectionUtils.isNotEmpty(toneList)) {
            return toneList;
        }
        return Collections.singletonList(chinese);
    }
}

