/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.support.tone;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.taotao.cloud.common.support.handler.IHandler;
import com.taotao.cloud.common.utils.collection.CollectionUtils;
import com.taotao.cloud.common.utils.io.FileStreamUtils;
import com.taotao.cloud.common.utils.lang.ObjectUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.pinyin.constant.enums.PinyinToneNumEnum;
import com.taotao.cloud.pinyin.model.CharToneInfo;
import com.taotao.cloud.pinyin.model.ToneItem;
import com.taotao.cloud.pinyin.spi.IPinyinToneStyle;
import com.taotao.cloud.pinyin.support.tone.AbstractPinyinTone;
import com.taotao.cloud.pinyin.util.InnerToneHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultPinyinTone
extends AbstractPinyinTone {
    private static volatile Map<String, List<String>> charMap;
    private static volatile Map<String, String> phraseMap;

    @Override
    protected List<String> getCharTones(String chinese, final IPinyinToneStyle toneStyle) {
        List<String> defaultList = this.getCharMap().get(chinese);
        return CollectionUtils.toList(defaultList, (IHandler)new IHandler<String, String>(){

            public String handle(String s) {
                return toneStyle.style(s);
            }
        });
    }

    @Override
    protected String getCharTone(String segment, IPinyinToneStyle toneStyle) {
        List<String> pinyinList = this.getCharMap().get(segment);
        if (CollectionUtils.isNotEmpty(pinyinList)) {
            String firstPinyin = pinyinList.get(0);
            return toneStyle.style(firstPinyin);
        }
        return null;
    }

    @Override
    protected String getPhraseTone(String segment, IPinyinToneStyle toneStyle, String connector) {
        String phrasePinyin = this.getPhraseMap().get(segment);
        if (StringUtils.isEmptyTrim((String)phrasePinyin)) {
            return "";
        }
        String[] strings = phrasePinyin.split(" ");
        ArrayList resultList = Lists.newArrayList();
        for (String string : strings) {
            String style = toneStyle.style(string);
            resultList.add(style);
        }
        return StringUtils.join((Collection)resultList, (String)connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getCharMap() {
        if (ObjectUtils.isNotNull(charMap)) {
            return charMap;
        }
        Class<DefaultPinyinTone> clazz = DefaultPinyinTone.class;
        synchronized (DefaultPinyinTone.class) {
            if (ObjectUtils.isNull(charMap)) {
                List lines = FileStreamUtils.readAllLines((String)"/pinyin/pinyin_dict_char.txt");
                List defineLines = FileStreamUtils.readAllLines((String)"/pinyin/pinyin_dict_char_define.txt");
                lines.addAll(defineLines);
                charMap = Maps.newHashMap();
                for (String line : lines) {
                    String[] strings = line.split(":");
                    List pinyinList = StringUtils.splitToList((String)strings[1]);
                    String word = strings[0];
                    charMap.put(word, pinyinList);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return charMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPhraseMap() {
        if (ObjectUtils.isNotNull(phraseMap)) {
            return phraseMap;
        }
        Class<DefaultPinyinTone> clazz = DefaultPinyinTone.class;
        synchronized (DefaultPinyinTone.class) {
            if (ObjectUtils.isNull(phraseMap)) {
                long startTime = System.currentTimeMillis();
                List lines = FileStreamUtils.readAllLines((String)"/pinyin/pinyin_dict_phrase.txt");
                List defineLines = FileStreamUtils.readAllLines((String)"/pinyin/pinyin_dict_phrase_define.txt");
                lines.addAll(defineLines);
                phraseMap = Maps.newHashMap();
                for (String line : lines) {
                    String[] strings = line.split(":");
                    String word = strings[0];
                    phraseMap.put(word, strings[1]);
                }
                long endTime = System.currentTimeMillis();
                System.out.println("[Pinyin] phrase dict loaded, cost time " + (endTime - startTime) + " ms!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return phraseMap;
        }
    }

    @Override
    public Set<String> phraseSet() {
        Map<String, String> map = this.getPhraseMap();
        return map.keySet();
    }

    @Override
    public int toneNum(String defaultPinyin) {
        if (StringUtils.isNotEmpty((CharSequence)defaultPinyin)) {
            CharToneInfo toneInfo = this.getCharToneInfo(defaultPinyin);
            int index = toneInfo.getIndex();
            if (index < 0) {
                return PinyinToneNumEnum.FIVE.num();
            }
            return toneInfo.getToneItem().getTone();
        }
        return PinyinToneNumEnum.UN_KNOWN.num();
    }

    protected CharToneInfo getCharToneInfo(String tone) {
        CharToneInfo charToneInfo = new CharToneInfo();
        charToneInfo.setIndex(-1);
        int length = tone.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = tone.charAt(i);
            ToneItem toneItem = InnerToneHelper.getToneItem(currentChar);
            if (!ObjectUtils.isNotNull((Object)toneItem)) continue;
            charToneInfo.setToneItem(toneItem);
            charToneInfo.setIndex(i);
            break;
        }
        return charToneInfo;
    }
}

