/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.pinyin.support.tone;

import com.google.common.collect.Maps;
import com.taotao.cloud.common.utils.io.FileStreamUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.pinyin.spi.IPinyinToneReverse;
import com.taotao.cloud.pinyin.spi.IPinyinToneStyle;
import com.taotao.cloud.pinyin.support.style.PinyinToneStyles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PinyinToneReverse
implements IPinyinToneReverse {
    private static final Map<String, List<String>> CHAR_MAP;

    @Override
    public List<String> getHanziList(String pinyinLast) {
        return CHAR_MAP.get(pinyinLast);
    }

    static {
        List lines = FileStreamUtils.readAllLines((String)"/pinyin/pinyin_dict_char.txt");
        List defineLines = FileStreamUtils.readAllLines((String)"/pinyin/pinyin_dict_char_define.txt");
        lines.addAll(defineLines);
        CHAR_MAP = Maps.newHashMap();
        IPinyinToneStyle pinyinToneStyle = PinyinToneStyles.numLast();
        for (String line : lines) {
            String[] strings = line.split(":");
            List pinyinList = StringUtils.splitToList((String)strings[1]);
            String hanzi = strings[0];
            for (String pinyin : pinyinList) {
                String pinyinNumLast = pinyinToneStyle.style(pinyin);
                List<String> hanziList = CHAR_MAP.get(pinyinNumLast);
                if (hanziList == null) {
                    hanziList = new ArrayList<String>();
                }
                hanziList.add(hanzi);
                CHAR_MAP.put(pinyinNumLast, hanziList);
            }
        }
    }
}

