/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.rxjava.async;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.observers.DisposableObserver;
import java.io.IOException;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

class ResponseBodyEmitterObserver<T>
extends DisposableObserver<T>
implements Runnable {
    private final MediaType mediaType;
    private final ResponseBodyEmitter responseBodyEmitter;
    private boolean completed;

    public ResponseBodyEmitterObserver(MediaType mediaType, Observable<T> observable, ResponseBodyEmitter responseBodyEmitter) {
        this.mediaType = mediaType;
        this.responseBodyEmitter = responseBodyEmitter;
        this.responseBodyEmitter.onTimeout((Runnable)this);
        this.responseBodyEmitter.onCompletion((Runnable)this);
        observable.subscribe((Observer)this);
    }

    public void onNext(T value) {
        try {
            if (!this.completed) {
                this.responseBodyEmitter.send(value, this.mediaType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void onError(Throwable e) {
        this.responseBodyEmitter.completeWithError(e);
    }

    public void onComplete() {
        if (!this.completed) {
            this.completed = true;
            this.responseBodyEmitter.complete();
        }
    }

    @Override
    public void run() {
        this.dispose();
    }
}

