/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.rxjava.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.rxjava.annotation.RxJava;
import com.taotao.cloud.rxjava.mvc.ObservableReturnValueHandler;
import com.taotao.cloud.rxjava.mvc.SingleReturnValueHandler;
import com.taotao.cloud.rxjava.properties.RxJavaProperties;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={RxJavaProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.rxjava", name={"enabled"}, havingValue="true")
public class RxJavaMvcAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RxJavaMvcAutoConfiguration.class, (String)"taotao-cloud-starter-rxjava", (String[])new String[0]);
    }

    @Bean
    @RxJava
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Observable.class})
    public ObservableReturnValueHandler observableReturnValueHandler() {
        LogUtils.started(ObservableReturnValueHandler.class, (String)"taotao-cloud-starter-rxjava", (String[])new String[0]);
        return new ObservableReturnValueHandler();
    }

    @Bean
    @RxJava
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Single.class})
    public SingleReturnValueHandler singleReturnValueHandler() {
        LogUtils.started(SingleReturnValueHandler.class, (String)"taotao-cloud-starter-rxjava", (String[])new String[0]);
        return new SingleReturnValueHandler();
    }

    @Configuration
    @ConditionalOnProperty(prefix="taotao.cloud.rxjava.mvc", name={"enabled"}, havingValue="true")
    public static class RxJavaWebConfiguration
    implements WebMvcConfigurer {
        @Autowired
        private List<AsyncHandlerMethodReturnValueHandler> handlers;

        public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
            if (this.handlers != null) {
                returnValueHandlers.addAll(this.handlers);
            }
        }
    }
}

