/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.rxjava.mvc;

import com.taotao.cloud.rxjava.async.ObservableDeferredResult;
import io.reactivex.Observable;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ObservableReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        return returnValue != null && this.supportsReturnType(returnType);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return Observable.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        Observable observable = (Observable)Observable.class.cast(returnValue);
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(new ObservableDeferredResult(observable), new Object[]{mavContainer});
    }
}

