/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.justauth.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.security.justauth.configuration.JustAuthStateCacheConfiguration;
import com.taotao.cloud.security.justauth.factory.AuthRequestFactory;
import com.taotao.cloud.security.justauth.properties.JustAuthProperties;
import me.zhyd.oauth.cache.AuthStateCache;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@EnableConfigurationProperties(value={JustAuthProperties.class})
public class JustAuthAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(JustAuthAutoConfiguration.class, (String)"taotao-cloud-starter-security-justauth", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnProperty(prefix="justauth", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public AuthRequestFactory authRequestFactory(JustAuthProperties properties, AuthStateCache authStateCache) {
        return new AuthRequestFactory(properties, authStateCache);
    }

    @Configuration
    @Import(value={JustAuthStateCacheConfiguration.Default.class, JustAuthStateCacheConfiguration.Redis.class, JustAuthStateCacheConfiguration.Custom.class})
    protected static class AuthStateCacheAutoConfiguration {
        protected AuthStateCacheAutoConfiguration() {
        }
    }
}

