/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.justauth.support.cache;

import com.taotao.cloud.security.justauth.properties.CacheProperties;
import java.util.concurrent.TimeUnit;
import me.zhyd.oauth.cache.AuthStateCache;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisStateCache
implements AuthStateCache {
    private final RedisTemplate<String, String> redisTemplate;
    private final CacheProperties cacheProperties;

    public RedisStateCache(RedisTemplate<String, String> redisTemplate, CacheProperties cacheProperties) {
        this.redisTemplate = redisTemplate;
        this.cacheProperties = cacheProperties;
    }

    public void cache(String key, String value) {
        this.cache(key, value, this.cacheProperties.getTimeout().toMillis());
    }

    public void cache(String key, String value, long timeout) {
        this.redisTemplate.opsForValue().set((Object)(this.cacheProperties.getPrefix() + key), (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)(this.cacheProperties.getPrefix() + key));
    }

    public boolean containsKey(String key) {
        Long expire = this.redisTemplate.getExpire((Object)(this.cacheProperties.getPrefix() + key), TimeUnit.MILLISECONDS);
        if (expire == null) {
            expire = 0L;
        }
        return expire > 0L;
    }
}

