/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.justauth.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.security.justauth.configuration.JustAuthAutoConfiguration;
import com.taotao.cloud.security.justauth.properties.JustAuthProperties;
import com.taotao.cloud.security.justauth.support.cache.RedisStateCache;
import me.zhyd.oauth.cache.AuthDefaultStateCache;
import me.zhyd.oauth.cache.AuthStateCache;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class JustAuthStateCacheConfiguration {

    @ConditionalOnProperty(name={"justauth.cache.type"}, havingValue="custom")
    public static class Custom
    implements InitializingBean {
        public void afterPropertiesSet() throws Exception {
            LogUtils.started(JustAuthAutoConfiguration.class, (String)"taotao-cloud-starter-security-justauth", (String[])new String[0]);
            LogUtils.info((String)"JustAuth \u4f7f\u7528 \u81ea\u5b9a\u4e49\u7f13\u5b58\u5b58\u50a8 state \u6570\u636e", (Object[])new Object[0]);
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthStateCache.class})
        public AuthStateCache authStateCache() {
            LogUtils.error((String)"\u8bf7\u81ea\u884c\u5b9e\u73b0 me.zhyd.oauth.cache.AuthStateCache", (Object[])new Object[0]);
            throw new RuntimeException();
        }
    }

    @ConditionalOnMissingBean(value={AuthStateCache.class})
    @ConditionalOnProperty(name={"justauth.cache.type"}, havingValue="default", matchIfMissing=true)
    public static class Default
    implements InitializingBean {
        public void afterPropertiesSet() throws Exception {
            LogUtils.started(JustAuthAutoConfiguration.class, (String)"taotao-cloud-starter-security-justauth", (String[])new String[0]);
            LogUtils.info((String)"JustAuth \u4f7f\u7528 \u9ed8\u8ba4\u7f13\u5b58\u5b58\u50a8 state \u6570\u636e", (Object[])new Object[0]);
        }

        @Bean
        public AuthStateCache authStateCache() {
            return AuthDefaultStateCache.INSTANCE;
        }
    }

    @ConditionalOnClass(value={RedisTemplate.class})
    @ConditionalOnMissingBean(value={AuthStateCache.class})
    @AutoConfigureBefore(value={RedisAutoConfiguration.class})
    @ConditionalOnProperty(name={"justauth.cache.type"}, havingValue="redis", matchIfMissing=true)
    public static class Redis
    implements InitializingBean {
        public void afterPropertiesSet() throws Exception {
            LogUtils.started(JustAuthAutoConfiguration.class, (String)"taotao-cloud-starter-security-justauth", (String[])new String[0]);
            LogUtils.info((String)"JustAuth \u4f7f\u7528 Redis \u7f13\u5b58\u5b58\u50a8 state \u6570\u636e", (Object[])new Object[0]);
        }

        @Bean(name={"justAuthRedisCacheTemplate"})
        public RedisTemplate<String, String> justAuthRedisCacheTemplate(RedisConnectionFactory redisConnectionFactory) {
            RedisTemplate template = new RedisTemplate();
            template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            template.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        public AuthStateCache authStateCache(RedisTemplate<String, String> justAuthRedisCacheTemplate, JustAuthProperties justAuthProperties) {
            return new RedisStateCache(justAuthRedisCacheTemplate, justAuthProperties.getCache());
        }
    }
}

