/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.justauth.factory;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.security.justauth.properties.ExtendProperties;
import com.taotao.cloud.security.justauth.properties.JustAuthProperties;
import com.xkcoding.http.config.HttpConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.request.AuthAlipayRequest;
import me.zhyd.oauth.request.AuthAliyunRequest;
import me.zhyd.oauth.request.AuthAmazonRequest;
import me.zhyd.oauth.request.AuthBaiduRequest;
import me.zhyd.oauth.request.AuthCodingRequest;
import me.zhyd.oauth.request.AuthCsdnRequest;
import me.zhyd.oauth.request.AuthDingTalkAccountRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;
import me.zhyd.oauth.request.AuthDouyinRequest;
import me.zhyd.oauth.request.AuthElemeRequest;
import me.zhyd.oauth.request.AuthFacebookRequest;
import me.zhyd.oauth.request.AuthFeishuRequest;
import me.zhyd.oauth.request.AuthGiteeRequest;
import me.zhyd.oauth.request.AuthGithubRequest;
import me.zhyd.oauth.request.AuthGitlabRequest;
import me.zhyd.oauth.request.AuthGoogleRequest;
import me.zhyd.oauth.request.AuthHuaweiRequest;
import me.zhyd.oauth.request.AuthJdRequest;
import me.zhyd.oauth.request.AuthKujialeRequest;
import me.zhyd.oauth.request.AuthLineRequest;
import me.zhyd.oauth.request.AuthLinkedinRequest;
import me.zhyd.oauth.request.AuthMeituanRequest;
import me.zhyd.oauth.request.AuthMiRequest;
import me.zhyd.oauth.request.AuthMicrosoftRequest;
import me.zhyd.oauth.request.AuthOktaRequest;
import me.zhyd.oauth.request.AuthOschinaRequest;
import me.zhyd.oauth.request.AuthPinterestRequest;
import me.zhyd.oauth.request.AuthQqRequest;
import me.zhyd.oauth.request.AuthRenrenRequest;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.AuthSlackRequest;
import me.zhyd.oauth.request.AuthStackOverflowRequest;
import me.zhyd.oauth.request.AuthTaobaoRequest;
import me.zhyd.oauth.request.AuthTeambitionRequest;
import me.zhyd.oauth.request.AuthToutiaoRequest;
import me.zhyd.oauth.request.AuthTwitterRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseQrcodeRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseWebRequest;
import me.zhyd.oauth.request.AuthWeChatMpRequest;
import me.zhyd.oauth.request.AuthWeChatOpenRequest;
import me.zhyd.oauth.request.AuthWeiboRequest;
import me.zhyd.oauth.request.AuthXmlyRequest;
import org.springframework.util.CollectionUtils;

public class AuthRequestFactory {
    private final JustAuthProperties properties;
    private final AuthStateCache authStateCache;

    public AuthRequestFactory(JustAuthProperties properties, AuthStateCache authStateCache) {
        this.properties = properties;
        this.authStateCache = authStateCache;
    }

    public List<String> oauthList() {
        ArrayList<String> defaultList = new ArrayList<String>(this.properties.getType().keySet());
        List<Object> extendList = new ArrayList();
        ExtendProperties extend = this.properties.getExtend();
        if (null != extend) {
            Class<? extends AuthSource> enumClass = extend.getEnumClass();
            List names = EnumUtil.getNames(enumClass);
            extendList = extend.getConfig().keySet().stream().map(String::toUpperCase).filter(names::contains).collect(Collectors.toList());
        }
        return (List)CollUtil.addAll(defaultList, extendList);
    }

    public AuthRequest get(String source) {
        if (StrUtil.isBlank((CharSequence)source)) {
            throw new AuthException(AuthResponseStatus.NO_AUTH_SOURCE);
        }
        AuthRequest authRequest = this.getDefaultRequest(source);
        if (authRequest == null) {
            authRequest = this.getExtendRequest(this.properties.getExtend().getEnumClass(), source);
        }
        if (authRequest == null) {
            throw new AuthException(AuthResponseStatus.UNSUPPORTED);
        }
        return authRequest;
    }

    private AuthRequest getExtendRequest(Class clazz, String source) {
        String upperSource = source.toUpperCase();
        try {
            EnumUtil.fromString((Class)clazz, (String)upperSource);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Map<String, ExtendProperties.ExtendRequestConfig> extendConfig = this.properties.getExtend().getConfig();
        HashMap upperConfig = new HashMap(6);
        extendConfig.forEach((k, v) -> upperConfig.put(k.toUpperCase(), v));
        ExtendProperties.ExtendRequestConfig extendRequestConfig = (ExtendProperties.ExtendRequestConfig)((Object)upperConfig.get(upperSource));
        if (extendRequestConfig != null) {
            this.configureHttpConfig(upperSource, extendRequestConfig, this.properties.getHttpConfig());
            Class<? extends AuthRequest> requestClass = extendRequestConfig.getRequestClass();
            if (requestClass != null) {
                return (AuthRequest)ReflectUtil.newInstance(requestClass, (Object[])new Object[]{extendRequestConfig, this.authStateCache});
            }
        }
        return null;
    }

    private AuthRequest getDefaultRequest(String source) {
        AuthDefaultSource authDefaultSource;
        try {
            authDefaultSource = (AuthDefaultSource)EnumUtil.fromString(AuthDefaultSource.class, (String)source.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        AuthConfig config = this.properties.getType().get(authDefaultSource.name());
        if (config == null) {
            return null;
        }
        this.configureHttpConfig(authDefaultSource.name(), config, this.properties.getHttpConfig());
        return switch (authDefaultSource) {
            case AuthDefaultSource.GITHUB -> new AuthGithubRequest(config, this.authStateCache);
            case AuthDefaultSource.WEIBO -> new AuthWeiboRequest(config, this.authStateCache);
            case AuthDefaultSource.GITEE -> new AuthGiteeRequest(config, this.authStateCache);
            case AuthDefaultSource.DINGTALK -> new AuthDingTalkRequest(config, this.authStateCache);
            case AuthDefaultSource.DINGTALK_ACCOUNT -> new AuthDingTalkAccountRequest(config, this.authStateCache);
            case AuthDefaultSource.BAIDU -> new AuthBaiduRequest(config, this.authStateCache);
            case AuthDefaultSource.CSDN -> new AuthCsdnRequest(config, this.authStateCache);
            case AuthDefaultSource.CODING -> new AuthCodingRequest(config, this.authStateCache);
            case AuthDefaultSource.OSCHINA -> new AuthOschinaRequest(config, this.authStateCache);
            case AuthDefaultSource.ALIPAY -> new AuthAlipayRequest(config, "", this.authStateCache);
            case AuthDefaultSource.QQ -> new AuthQqRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_OPEN -> new AuthWeChatOpenRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_MP -> new AuthWeChatMpRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_ENTERPRISE -> new AuthWeChatEnterpriseQrcodeRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_ENTERPRISE_WEB -> new AuthWeChatEnterpriseWebRequest(config, this.authStateCache);
            case AuthDefaultSource.TAOBAO -> new AuthTaobaoRequest(config, this.authStateCache);
            case AuthDefaultSource.GOOGLE -> new AuthGoogleRequest(config, this.authStateCache);
            case AuthDefaultSource.FACEBOOK -> new AuthFacebookRequest(config, this.authStateCache);
            case AuthDefaultSource.DOUYIN -> new AuthDouyinRequest(config, this.authStateCache);
            case AuthDefaultSource.LINKEDIN -> new AuthLinkedinRequest(config, this.authStateCache);
            case AuthDefaultSource.MICROSOFT -> new AuthMicrosoftRequest(config, this.authStateCache);
            case AuthDefaultSource.MI -> new AuthMiRequest(config, this.authStateCache);
            case AuthDefaultSource.TOUTIAO -> new AuthToutiaoRequest(config, this.authStateCache);
            case AuthDefaultSource.TEAMBITION -> new AuthTeambitionRequest(config, this.authStateCache);
            case AuthDefaultSource.RENREN -> new AuthRenrenRequest(config, this.authStateCache);
            case AuthDefaultSource.PINTEREST -> new AuthPinterestRequest(config, this.authStateCache);
            case AuthDefaultSource.STACK_OVERFLOW -> new AuthStackOverflowRequest(config, this.authStateCache);
            case AuthDefaultSource.HUAWEI -> new AuthHuaweiRequest(config, this.authStateCache);
            case AuthDefaultSource.GITLAB -> new AuthGitlabRequest(config, this.authStateCache);
            case AuthDefaultSource.KUJIALE -> new AuthKujialeRequest(config, this.authStateCache);
            case AuthDefaultSource.ELEME -> new AuthElemeRequest(config, this.authStateCache);
            case AuthDefaultSource.MEITUAN -> new AuthMeituanRequest(config, this.authStateCache);
            case AuthDefaultSource.TWITTER -> new AuthTwitterRequest(config, this.authStateCache);
            case AuthDefaultSource.FEISHU -> new AuthFeishuRequest(config, this.authStateCache);
            case AuthDefaultSource.JD -> new AuthJdRequest(config, this.authStateCache);
            case AuthDefaultSource.ALIYUN -> new AuthAliyunRequest(config, this.authStateCache);
            case AuthDefaultSource.XMLY -> new AuthXmlyRequest(config, this.authStateCache);
            case AuthDefaultSource.AMAZON -> new AuthAmazonRequest(config, this.authStateCache);
            case AuthDefaultSource.SLACK -> new AuthSlackRequest(config, this.authStateCache);
            case AuthDefaultSource.LINE -> new AuthLineRequest(config, this.authStateCache);
            case AuthDefaultSource.OKTA -> new AuthOktaRequest(config, this.authStateCache);
            default -> null;
        };
    }

    private void configureHttpConfig(String authSource, AuthConfig authConfig, JustAuthProperties.JustAuthHttpConfig httpConfig) {
        if (null == httpConfig) {
            return;
        }
        Map<String, JustAuthProperties.JustAuthProxyConfig> proxyConfigMap = httpConfig.getProxy();
        if (CollectionUtils.isEmpty(proxyConfigMap)) {
            return;
        }
        JustAuthProperties.JustAuthProxyConfig proxyConfig = proxyConfigMap.get(authSource);
        if (null == proxyConfig) {
            return;
        }
        authConfig.setHttpConfig(HttpConfig.builder().timeout(httpConfig.getTimeout()).proxy(new Proxy(Proxy.Type.valueOf(proxyConfig.getType()), new InetSocketAddress(proxyConfig.getHostname(), proxyConfig.getPort()))).build());
    }
}

