/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.satoken.configuration;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.filter.SaServletFilter;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.dev33.satoken.jwt.StpLogicJwtForSimple;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.security.satoken.configuration.MySaTokenListener;
import com.taotao.cloud.security.satoken.configuration.SaLogForSlf4j;
import com.taotao.cloud.security.satoken.configuration.StpInterfaceImpl;
import com.taotao.cloud.security.satoken.configuration.StpUserUtil;
import com.taotao.cloud.security.satoken.ignore.router.IgnoreSaRouteFunction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Configuration
@Import(value={MySaTokenListener.class, SaLogForSlf4j.class, StpInterfaceImpl.class, StpUserUtil.class})
public class SaTokenConfiguration
implements WebMvcConfigurer,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SaTokenConfiguration.class, (String)"taotao-cloud-starter-security-satoken", (String[])new String[0]);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new SaInterceptor(handle -> {
            SaRouter.match((String[])new String[]{"/user/**"}).notMatch(new String[]{"/user/doLogin", "/user/doLogin2"}).check(r -> StpUtil.checkLogin());
            SaRouter.match((String)"/admin/**", r -> StpUtil.checkPermission((String)"admin"));
            SaRouter.match((String)"/goods/**", r -> StpUtil.checkPermission((String)"goods"));
            SaRouter.match((String)"/orders/**", r -> StpUtil.checkPermission((String)"orders"));
            SaRouter.match((String)"/notice/**", r -> StpUtil.checkPermission((String)"notice"));
            SaRouter.match((String)"/comment/**", r -> StpUtil.checkPermission((String)"comment"));
            SaRouter.match((String)"/router/print", r -> System.out.println("----\u5566\u5566\u5566----"));
            SaRouter.match((String)"/router/print2", r -> System.out.println("----\u5566\u5566\u55662----"));
            SaRouter.match((String)"/**", (String)"/login", (SaFunction)new IgnoreSaRouteFunction(handle));
        })).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public SaServletFilter getSaServletFilter() {
        return new SaServletFilter().addInclude(new String[]{"/**"}).addExclude(new String[]{"/favicon.ico"}).setAuth(obj -> {
            SaRouter.match((String)"/admin/**", r -> StpUtil.checkPermission((String)"admin"));
            SaRouter.match((String)"/goods/**", r -> StpUtil.checkPermission((String)"goods"));
            SaRouter.match((String)"/orders/**", r -> StpUtil.checkPermission((String)"orders"));
            SaRouter.match((String)"/notice/**", r -> StpUtil.checkPermission((String)"notice"));
            SaRouter.match((String)"/comment/**", r -> StpUtil.checkPermission((String)"comment"));
        }).setError(e -> {
            System.out.println("---------- sa\u5168\u5c40\u5f02\u5e38 ");
            return SaResult.error((String)e.getMessage());
        }).setBeforeAuth(r -> SaHolder.getResponse().setServer("sa-server").setHeader("X-Frame-Options", "SAMEORIGIN").setHeader("X-XSS-Protection", "1; mode=block").setHeader("X-Content-Type-Options", "nosniff"));
    }

    @Autowired
    public void rewriteSaStrategy() {
        SaStrategy.me.getAnnotation = AnnotatedElementUtils::getMergedAnnotation;
        SaStrategy.me.createToken = (loginId, loginType) -> SaFoxUtil.getRandomString((int)60);
    }

    @Bean
    public StpLogic getStpLogicJwt() {
        return new StpLogicJwtForSimple();
    }
}

