/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.springsecurity.access;

import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;

public class RoleExpressionAccessDecisionManager
extends AbstractAccessDecisionManager {
    private ScriptEngineManager manager = new ScriptEngineManager();
    private ScriptEngine engine = this.manager.getEngineByName("js");
    @Autowired
    private RedisRepository redisRepository;

    public RoleExpressionAccessDecisionManager(List<AccessDecisionVoter<?>> decisionVoters) {
        super(decisionVoters);
    }

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        String attribute;
        ConfigAttribute configAttribute = configAttributes.iterator().next();
        String originScript = attribute = configAttribute.getAttribute();
        if (attribute.contains("anon")) {
            return;
        }
        if (attribute.contains("authc")) {
            if (authentication == null || authentication.getPrincipal() == null || "anonymousUser".equals(authentication.getPrincipal())) {
                throw new AccessDeniedException("\u9700\u8981\u767b\u5f55");
            }
            return;
        }
        Collection authorities = authentication.getAuthorities();
        for (Object authority : authorities) {
            String userHasRole = authority.getAuthority();
            attribute = attribute.replaceAll(userHasRole, "true");
        }
        ArrayList allRoles = new ArrayList();
        for (String role : allRoles) {
            attribute = attribute.replaceAll(role, "false");
        }
        try {
            Object eval = this.engine.eval(attribute);
            if (!(eval instanceof Boolean)) {
                throw new AccessDeniedException(Objects.toString(eval));
            }
            if (!((Boolean)eval).booleanValue()) {
                throw new AccessDeniedException("\u6743\u9650\u4e0d\u8db32");
            }
        }
        catch (ScriptException e) {
            LogUtils.error((String)"\u811a\u672c\u6267\u884c\u9519\u8bef:[origin:{}][parse:{}][message:{}]", (Object[])new Object[]{originScript, attribute, e.getMessage()});
            throw new AccessDeniedException("\u6743\u9650\u4e0d\u8db3");
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return false;
    }

    public boolean supports(Class<?> clazz) {
        return false;
    }
}

