/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.springsecurity.configuration;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.support.function.FuncUtil;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.ResponseUtils;
import com.taotao.cloud.security.springsecurity.access.RoleBasedVoter;
import com.taotao.cloud.security.springsecurity.access.UrlSecurityPermsLoad;
import com.taotao.cloud.security.springsecurity.annotation.NotAuth;
import com.taotao.cloud.security.springsecurity.perm.VipAccessDecisionManager;
import com.taotao.cloud.security.springsecurity.perm.VipSecurityOauthService;
import com.taotao.cloud.security.springsecurity.properties.SecurityProperties;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

@AutoConfiguration
public class Oauth2ResourceAutoConfiguration
implements InitializingBean {
    @Autowired(required=false)
    private DiscoveryClient discoveryClient;
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private CacheManager redisCacheManager;
    @Value(value="${spring.security.oauth2.resourceserver.jwt.jwk-set-uri:''}")
    private String jwkSetUri;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(Oauth2ResourceAutoConfiguration.class, (String)"taotao-cloud-starter-security-springsecurity", (String[])new String[0]);
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        if (Objects.nonNull(this.discoveryClient)) {
            this.jwkSetUri = this.discoveryClient.getServices().stream().filter(s -> s.contains("taotao-cloud-auth")).flatMap(s -> this.discoveryClient.getInstances(s).stream()).map(instance -> String.format("http://%s:%s/oauth2/jwks", instance.getHost(), instance.getPort())).findFirst().orElse(this.jwkSetUri);
        }
        NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder jwkSetUriJwtDecoderBuilder = NimbusJwtDecoder.withJwkSetUri((String)((String)FuncUtil.predicate((Object)this.jwkSetUri, CharSequenceUtil::isBlank, (Object)"http://127.0.0.1:33336/oauth2/jwks"))).jwsAlgorithm(SignatureAlgorithm.RS256);
        Cache cache = this.redisCacheManager.getCache("jwt");
        if (cache != null) {
            jwkSetUriJwtDecoderBuilder.cache(cache);
        }
        NimbusJwtDecoder nimbusJwtDecoder = jwkSetUriJwtDecoderBuilder.build();
        nimbusJwtDecoder.setJwtValidator(JwtValidators.createDefault());
        return nimbusJwtDecoder;
    }

    JwtAuthenticationConverter jwtAuthenticationConverter() {
        CustomJwtGrantedAuthoritiesConverter grantedAuthoritiesConverter = new CustomJwtGrantedAuthoritiesConverter();
        grantedAuthoritiesConverter.setAuthorityPrefix("");
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)grantedAuthoritiesConverter);
        return jwtAuthenticationConverter;
    }

    @Bean
    public VipSecurityOauthService vipSecurityOauthService() {
        return new VipSecurityOauthService();
    }

    @Bean
    public VipAccessDecisionManager vipAccessDecisionManager() {
        return new VipAccessDecisionManager();
    }

    @Bean
    public RoleBasedVoter roleBasedVoter() {
        return new RoleBasedVoter();
    }

    @Bean
    public UrlSecurityPermsLoad urlSecurityPermsLoad() {
        return new UrlSecurityPermsLoad();
    }

    @Bean
    public SecurityFilterChain oauth2ResourceSecurityFilterChain(HttpSecurity http) throws Exception {
        HttpSecurity httpSecurity = ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).csrf().disable()).formLogin().disable()).authorizeHttpRequests(registry -> {
            this.permitAllUrls((AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry)registry, (ApplicationContext)http.getSharedObject(ApplicationContext.class));
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
        }).oauth2ResourceServer(config -> config.accessDeniedHandler((request, response, accessDeniedException) -> {
            LogUtils.error((String)"\u7528\u6237\u6743\u9650\u4e0d\u8db3", (Object[])new Object[]{accessDeniedException});
            ResponseUtils.fail((HttpServletResponse)response, (ResultEnum)ResultEnum.FORBIDDEN);
        }).authenticationEntryPoint((request, response, authException) -> {
            LogUtils.error((String)"\u7528\u6237\u672a\u767b\u5f55\u8ba4\u8bc1\u5931\u8d25", (Object[])new Object[]{authException});
            ResponseUtils.fail((HttpServletResponse)response, (ResultEnum)ResultEnum.UNAUTHORIZED);
        }).bearerTokenResolver((BearerTokenResolver)this.bearerTokenResolver()).jwt(jwt -> jwt.decoder(this.jwtDecoder()).jwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter())));
        return (SecurityFilterChain)httpSecurity.build();
    }

    private void permitAllUrls(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry registry, ApplicationContext ac) {
        List<String> permitAllUrls = this.securityProperties.getIgnoreUrl();
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)ac.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        map.keySet().forEach(info -> {
            HandlerMethod handlerMethod = (HandlerMethod)map.get(info);
            HashSet<NotAuth> set = new HashSet<NotAuth>();
            set.add((NotAuth)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), NotAuth.class));
            set.add((NotAuth)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), NotAuth.class));
            set.forEach(annotation -> Optional.ofNullable(annotation).flatMap(inner -> Optional.ofNullable(info.getPathPatternsCondition())).ifPresent(pathPatternsRequestCondition -> permitAllUrls.addAll(pathPatternsRequestCondition.getPatterns().stream().map(PathPattern::getPatternString).toList())));
        });
        permitAllUrls.forEach(url -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(new String[]{url})).permitAll());
        LogUtils.info((String)"permit all urls: {}", (Object[])new Object[]{permitAllUrls.toString()});
    }

    private DefaultBearerTokenResolver bearerTokenResolver() {
        DefaultBearerTokenResolver defaultBearerTokenResolver = new DefaultBearerTokenResolver();
        defaultBearerTokenResolver.setAllowFormEncodedBodyParameter(true);
        defaultBearerTokenResolver.setAllowUriQueryParameter(true);
        return defaultBearerTokenResolver;
    }

    public static class CustomJwtGrantedAuthoritiesConverter
    implements Converter<Jwt, Collection<GrantedAuthority>> {
        private final Log logger = LogFactory.getLog(this.getClass());
        private static final String DEFAULT_AUTHORITY_PREFIX = "SCOPE_";
        private static final Collection<String> WELL_KNOWN_AUTHORITIES_CLAIM_NAMES = Arrays.asList("scope", "scp");
        private String authorityPrefix = "SCOPE_";
        private String authoritiesClaimName;

        public Collection<GrantedAuthority> convert(Jwt jwt) {
            ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
            for (String authority : this.getAuthorities(jwt)) {
                grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.authorityPrefix + authority));
            }
            return grantedAuthorities;
        }

        public void setAuthorityPrefix(String authorityPrefix) {
            this.authorityPrefix = authorityPrefix;
        }

        public void setAuthoritiesClaimName(String authoritiesClaimName) {
            Assert.hasText((String)authoritiesClaimName, (String)"authoritiesClaimName cannot be empty");
            this.authoritiesClaimName = authoritiesClaimName;
        }

        private String getAuthoritiesClaimName(Jwt jwt) {
            if (this.authoritiesClaimName != null) {
                return this.authoritiesClaimName;
            }
            for (String claimName : WELL_KNOWN_AUTHORITIES_CLAIM_NAMES) {
                if (!jwt.hasClaim(claimName)) continue;
                return claimName;
            }
            return null;
        }

        private Collection<String> getAuthorities(Jwt jwt) {
            Object authorities;
            String claimName = this.getAuthoritiesClaimName(jwt);
            if (claimName == null) {
                this.logger.trace((Object)"Returning no authorities since could not find any claims that might contain scopes");
                return Collections.emptyList();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Looking for scopes in claim %s", (Object)claimName));
            }
            if ((authorities = jwt.getClaim(claimName)) instanceof String) {
                if (StringUtils.hasText((String)((String)authorities))) {
                    return Arrays.asList(((String)authorities).split(" "));
                }
                return Collections.emptyList();
            }
            if (authorities instanceof Collection) {
                return (Collection)authorities;
            }
            return Collections.emptyList();
        }

        private Collection<String> castAuthoritiesToCollection(Object authorities) {
            return (Collection)authorities;
        }
    }

    @Configuration
    @ConditionalOnNacosDiscoveryEnabled
    public static class NimbusReactiveJwtDecoderNacosServiceListener
    implements InitializingBean {
        @Autowired
        private NacosServiceManager nacosServiceManager;
        @Autowired
        private NacosDiscoveryProperties properties;

        public void afterPropertiesSet() throws Exception {
            this.nacosServiceManager.getNamingService(this.properties.getNacosProperties()).subscribe("taotao-cloud-auth", this.properties.getGroup(), List.of(this.properties.getClusterName()), event -> {
                if (event instanceof NamingEvent) {
                    List instances = ((NamingEvent)event).getInstances();
                    if (instances.isEmpty()) {
                        return;
                    }
                    Instance instance = (Instance)instances.get(0);
                    String jwkSetUri = String.format("http://%s:%s/oauth2/jwks", instance.getIp(), instance.getPort());
                    NimbusReactiveJwtDecoder nimbusReactiveJwtDecoder = NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(SignatureAlgorithm.RS256).build();
                    nimbusReactiveJwtDecoder.setJwtValidator(JwtValidators.createDefault());
                    ContextUtils.destroySingletonBean((String)"reactiveJwtDecoder");
                    ContextUtils.registerSingletonBean((String)"reactiveJwtDecoder", (Object)nimbusReactiveJwtDecoder);
                }
            });
        }
    }
}

