/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.springsecurity.configuration;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.ResponseUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.RequestMatcher;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SecurityAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SecurityAutoConfiguration.class, (String)"taotao-cloud-starter-security-springsecurity", (String[])new String[0]);
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new AuthenticationEntryPointComponent();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public static class AuthenticationEntryPointComponent
    implements AuthenticationEntryPoint {
        private final RequestMatcher authorizationCodeGrantRequestMatcher = new AuthorizationCodeGrantRequestMatcher();
        private final AuthenticationEntryPoint loginUrlAuthenticationEntryPoint = new LoginUrlAuthenticationEntryPoint("/auth/login");

        public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
            LogUtils.error((String)"\u8ba4\u8bc1\u5931\u8d25", (Object[])new Object[]{authException});
            if (this.authorizationCodeGrantRequestMatcher.matches(request)) {
                this.loginUrlAuthenticationEntryPoint.commence(request, response, authException);
                return;
            }
            ResponseUtils.fail((HttpServletResponse)response, (ResultEnum)ResultEnum.UNAUTHORIZED);
        }

        private static class AuthorizationCodeGrantRequestMatcher
        implements RequestMatcher {
            private final Set<String> SUPPORT_URIS = new HashSet<String>(Arrays.asList("response_type=code", "response_type=token"));

            private AuthorizationCodeGrantRequestMatcher() {
            }

            public boolean matches(HttpServletRequest request) {
                if (StringUtils.equals((CharSequence)request.getServletPath(), (CharSequence)"/oauth/authorize")) {
                    String queryString = request.getQueryString();
                    return this.SUPPORT_URIS.stream().anyMatch(supportUri -> StringUtils.indexOf((CharSequence)queryString, (CharSequence)supportUri) != -1);
                }
                return false;
            }
        }
    }
}

