/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.springsecurity.access;

import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.security.springsecurity.access.UrlSecurityPermsLoad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class RoleBasedVoter
implements AccessDecisionVoter<Object> {
    @Autowired
    private UrlSecurityPermsLoad urlPermsLoad;
    @Autowired
    private RedisRepository redisRepository;
    private ScriptEngineManager manager = new ScriptEngineManager();
    private ScriptEngine engine = this.manager.getEngineByName("js");
    public static final Pattern pattern = Pattern.compile("(\\w+)");

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(FilterInvocation.class);
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication == null) {
            return -1;
        }
        Collection authorities = authentication.getAuthorities();
        for (ConfigAttribute attribute : attributes) {
            if (attribute.getAttribute() == null || !this.supports(attribute)) continue;
            for (GrantedAuthority authority : authorities) {
                if (!attribute.getAttribute().equals(authority.getAuthority())) continue;
                return 1;
            }
        }
        FilterInvocation fi = (FilterInvocation)object;
        String url = fi.getRequestUrl();
        String matchRoles = this.urlPermsLoad.findMatchRoles(url);
        if (StringUtils.isBlank((CharSequence)matchRoles)) {
            return 0;
        }
        if (matchRoles.contains("anon")) {
            return 1;
        }
        if (matchRoles.contains("authc") && "anonymousUser".equals(authentication.getPrincipal())) {
            return -1;
        }
        String originScript = matchRoles;
        for (Object authority : authorities) {
            String userHasRole = authority.getAuthority();
            matchRoles = matchRoles.replaceAll(userHasRole, "true");
        }
        ArrayList allRoles = new ArrayList();
        for (String role : allRoles) {
            matchRoles = matchRoles.replaceAll(role, "false");
        }
        try {
            Matcher matcher = pattern.matcher(originScript);
            while (matcher.find()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    matchRoles = matchRoles.replaceAll(matcher.group(i), "undefined");
                }
            }
        }
        catch (Exception e) {
            LogUtils.warn((String)"\u6b63\u5219\u5339\u914d\u9519\u8bef,\u53ef\u80fd\u811a\u672c\u5b58\u5728\u95ee\u9898:{}", (Object[])new Object[]{e.getMessage()});
        }
        try {
            Object eval = this.engine.eval(matchRoles);
            if (!(eval instanceof Boolean)) {
                LogUtils.error((String)"\u811a\u672c\u6267\u884c\u5931\u8d25,\u8fd4\u56de\u503c\u975e Bool \u7c7b\u578b,\u9ed8\u8ba4\u662f\u7981\u6b62\u8bbf\u95ee:{},{}", (Object[])new Object[]{originScript, matchRoles});
                return -1;
            }
            if (((Boolean)eval).booleanValue()) {
                // empty if block
            }
            return (Boolean)eval != false ? 1 : -1;
        }
        catch (ScriptException e) {
            LogUtils.error((String)"\u811a\u672c\u6267\u884c\u9519\u8bef:[origin:{}][parse:{}][message:{}]", (Object[])new Object[]{originScript, matchRoles, e.getMessage()});
            return -1;
        }
    }
}

