/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.springsecurity.configuration;

import cn.hutool.core.collection.CollectionUtil;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.RequestUtils;
import java.io.Serializable;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class MethodSecurityAutoConfiguration
extends GlobalMethodSecurityConfiguration
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MethodSecurityAutoConfiguration.class, (String)"taotao-cloud-starter-security-springsecurity", (String[])new String[0]);
    }

    protected MethodSecurityExpressionHandler createExpressionHandler() {
        DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();
        expressionHandler.setPermissionEvaluator((PermissionEvaluator)new StandardPermissionEvaluator());
        expressionHandler.setApplicationContext(this.applicationContext);
        return expressionHandler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean(name={"pms"})
    public PermissionVerifier permissionVerifier() {
        return new PermissionVerifier();
    }

    public static class StandardPermissionEvaluator
    implements PermissionEvaluator {
        private static final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();

        public boolean hasPermission(Authentication auth, Object targetDomainObject, Object permission) {
            if (auth == null || targetDomainObject == null || !(permission instanceof String)) {
                return false;
            }
            String targetType = targetDomainObject.getClass().getSimpleName().toUpperCase();
            return this.hasPrivilege(auth, targetType, permission.toString().toUpperCase());
        }

        public boolean hasPermission(Authentication auth, Serializable targetId, String targetType, Object permission) {
            if (auth == null || targetType == null || !(permission instanceof String)) {
                return false;
            }
            return this.hasPrivilege(auth, targetType.toUpperCase(), permission.toString().toUpperCase());
        }

        private boolean hasPrivilege(Authentication auth, String targetType, String permission) {
            String header = RequestUtils.getHeader((String)"taotao-cloud-from-inner");
            if (Boolean.TRUE.equals(Boolean.valueOf(header))) {
                return true;
            }
            for (GrantedAuthority grantedAuth : auth.getAuthorities()) {
                if (!grantedAuth.getAuthority().contains(permission)) continue;
                return true;
            }
            return false;
        }

        public boolean checkInner() {
            HttpServletRequest request = RequestUtils.getRequest();
            return true;
        }
    }

    public static class PermissionVerifier {
        public boolean hasPermission(HttpServletRequest req, Authentication authentication, String permission) {
            return false;
        }

        public boolean hasPermission(String permission) {
            String header = RequestUtils.getHeader((String)"taotao-cloud-from-inner");
            if (Boolean.TRUE.equals(Boolean.valueOf(header))) {
                return true;
            }
            Collection authorities = SecurityUtils.getAuthentication().getAuthorities();
            if (CollectionUtil.isEmpty((Collection)authorities)) {
                return false;
            }
            for (GrantedAuthority grantedAuthority : authorities) {
                String authority = grantedAuthority.getAuthority();
                if (!authority.contains(permission)) continue;
                return true;
            }
            return false;
        }
    }
}

