/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.security.springsecurity.login;

import com.taotao.cloud.common.utils.log.LogUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class CustomOAuth2AuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Autowired
    private OAuth2AuthorizedClientRepository authorizedClientRepository;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LogUtils.info((String)"\u7528\u6237\u767b\u5f55\u6210\u529f {}", (Object[])new Object[]{authentication});
        OAuth2AuthenticationToken oauth2Authentication = (OAuth2AuthenticationToken)authentication;
        String clientId = oauth2Authentication.getAuthorizedClientRegistrationId();
        OAuth2AuthorizedClient oAuth2AuthorizedClient = this.authorizedClientRepository.loadAuthorizedClient(clientId, (Authentication)oauth2Authentication, request);
        Object redirectUrl = (String)request.getSession().getAttribute("redirect_uri");
        redirectUrl = (String)redirectUrl + (((String)redirectUrl).contains("?") ? "&" : "?");
        response.sendRedirect((String)redirectUrl + "access_token=" + oAuth2AuthorizedClient.getAccessToken().getTokenValue());
    }
}

