/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sensitive.sensitive.word.support.check.impl;

import com.taotao.cloud.common.support.instance.impl.Instances;
import com.taotao.cloud.common.utils.lang.ObjectUtils;
import com.taotao.cloud.sensitive.sensitive.word.api.IWordContext;
import com.taotao.cloud.sensitive.sensitive.word.constant.enums.ValidModeEnum;
import com.taotao.cloud.sensitive.sensitive.word.support.check.ISensitiveCheck;
import com.taotao.cloud.sensitive.sensitive.word.support.check.SensitiveCheckResult;
import com.taotao.cloud.sensitive.sensitive.word.support.format.CharFormatChain;
import java.util.Map;

public class SensitiveCheckWord
implements ISensitiveCheck {
    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        Map nowMap = context.sensitiveWordMap();
        int lengthCount = 0;
        int actualLength = 0;
        for (int i = beginIndex; i < txt.length() && ObjectUtils.isNotNull((Object)(nowMap = this.getNowMap(nowMap, context, txt, i))); ++i) {
            ++lengthCount;
            boolean isEnd = SensitiveCheckWord.isEnd(nowMap);
            if (!isEnd) continue;
            actualLength = lengthCount;
            if (ValidModeEnum.FAIL_FAST.equals((Object)validModeEnum)) break;
        }
        return SensitiveCheckResult.of(actualLength, SensitiveCheckWord.class);
    }

    private static boolean isEnd(Map map) {
        if (ObjectUtils.isNull((Object)map)) {
            return false;
        }
        Object value = map.get("ED");
        if (ObjectUtils.isNull(value)) {
            return false;
        }
        return (Boolean)value;
    }

    private Map getNowMap(Map nowMap, IWordContext context, String txt, int index) {
        char c = txt.charAt(index);
        char mappingChar = ((CharFormatChain)Instances.singleton(CharFormatChain.class)).format(c, context);
        Map currentMap = (Map)nowMap.get(Character.valueOf(mappingChar));
        if (context.ignoreRepeat() && index > 0) {
            char preChar = txt.charAt(index - 1);
            char preMappingChar = ((CharFormatChain)Instances.singleton(CharFormatChain.class)).format(preChar, context);
            if (preMappingChar == mappingChar) {
                currentMap = nowMap;
            }
        }
        return currentMap;
    }
}

