/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sensitive.sensitive.word.support.format;

import com.google.common.collect.Lists;
import com.taotao.cloud.common.support.instance.impl.Instances;
import com.taotao.cloud.sensitive.sensitive.word.api.ICharFormat;
import com.taotao.cloud.sensitive.sensitive.word.api.IWordContext;
import com.taotao.cloud.sensitive.sensitive.word.support.format.IgnoreCaseCharFormat;
import com.taotao.cloud.sensitive.sensitive.word.support.format.IgnoreChineseStyleFormat;
import com.taotao.cloud.sensitive.sensitive.word.support.format.IgnoreEnglishStyleFormat;
import com.taotao.cloud.sensitive.sensitive.word.support.format.IgnoreNumStyleCharFormat;
import com.taotao.cloud.sensitive.sensitive.word.support.format.IgnoreWidthCharFormat;
import java.util.ArrayList;

public class CharFormatChain
implements ICharFormat {
    @Override
    public char format(char original, IWordContext context) {
        char result = original;
        ArrayList charFormats = Lists.newArrayList();
        if (context.ignoreEnglishStyle()) {
            charFormats.add((ICharFormat)Instances.singleton(IgnoreEnglishStyleFormat.class));
        }
        if (context.ignoreCase()) {
            charFormats.add((ICharFormat)Instances.singleton(IgnoreCaseCharFormat.class));
        }
        if (context.ignoreWidth()) {
            charFormats.add((ICharFormat)Instances.singleton(IgnoreWidthCharFormat.class));
        }
        if (context.ignoreNumStyle()) {
            charFormats.add((ICharFormat)Instances.singleton(IgnoreNumStyleCharFormat.class));
        }
        if (context.ignoreChineseStyle()) {
            charFormats.add((ICharFormat)Instances.singleton(IgnoreChineseStyleFormat.class));
        }
        for (ICharFormat charFormat : charFormats) {
            result = charFormat.format(result, context);
        }
        return result;
    }
}

