/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sensitive.sensitive.word.support.map;

import com.google.common.collect.Lists;
import com.taotao.cloud.common.support.instance.impl.Instances;
import com.taotao.cloud.common.utils.collection.CollectionUtils;
import com.taotao.cloud.common.utils.io.FileUtils;
import com.taotao.cloud.common.utils.lang.ObjectUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sensitive.sensitive.word.api.ISensitiveWordReplace;
import com.taotao.cloud.sensitive.sensitive.word.api.IWordContext;
import com.taotao.cloud.sensitive.sensitive.word.api.IWordMap;
import com.taotao.cloud.sensitive.sensitive.word.api.IWordResult;
import com.taotao.cloud.sensitive.sensitive.word.constant.enums.ValidModeEnum;
import com.taotao.cloud.sensitive.sensitive.word.support.check.ISensitiveCheck;
import com.taotao.cloud.sensitive.sensitive.word.support.check.SensitiveCheckResult;
import com.taotao.cloud.sensitive.sensitive.word.support.check.impl.SensitiveCheckChain;
import com.taotao.cloud.sensitive.sensitive.word.support.check.impl.SensitiveCheckUrl;
import com.taotao.cloud.sensitive.sensitive.word.support.replace.SensitiveWordReplaceContext;
import com.taotao.cloud.sensitive.sensitive.word.support.result.WordResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SensitiveWordMap
implements IWordMap {
    private Map innerWordMap;

    @Override
    public synchronized void initWordMap(Collection<String> collection) {
        long startTime = System.currentTimeMillis();
        HashMap newInnerWordMap = new HashMap(collection.size());
        for (String key : collection) {
            if (StringUtils.isEmpty((String)key)) continue;
            char[] chars = key.toCharArray();
            int size = chars.length;
            Map<Object, Serializable> currentMap = newInnerWordMap;
            for (int i = 0; i < size; ++i) {
                char charKey = chars[i];
                Object wordMap = currentMap.get(Character.valueOf(charKey));
                if (ObjectUtils.isNotNull(wordMap)) {
                    currentMap = (Map)wordMap;
                } else {
                    HashMap<String, Boolean> newWordMap = new HashMap<String, Boolean>(8);
                    newWordMap.put("ED", false);
                    currentMap.put(Character.valueOf(charKey), newWordMap);
                    currentMap = newWordMap;
                }
                if (i != size - 1) continue;
                currentMap.put("ED", Boolean.valueOf(true));
            }
        }
        this.innerWordMap = newInnerWordMap;
        long endTime = System.currentTimeMillis();
        LogUtils.info((String)("Init sensitive word map end! Cost time: " + (endTime - startTime) + "ms"), (Object[])new Object[0]);
    }

    @Override
    public boolean contains(String string, IWordContext context) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            SensitiveCheckResult checkResult = this.sensitiveCheck(string, i, ValidModeEnum.FAIL_FAST, context);
            if (checkResult.index() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IWordResult> findAll(String string, IWordContext context) {
        return this.getSensitiveWords(string, ValidModeEnum.FAIL_OVER, context);
    }

    @Override
    public IWordResult findFirst(String string, IWordContext context) {
        List<IWordResult> stringList = this.getSensitiveWords(string, ValidModeEnum.FAIL_FAST, context);
        if (CollectionUtils.isEmpty(stringList)) {
            return null;
        }
        return stringList.get(0);
    }

    @Override
    public String replace(String target, ISensitiveWordReplace replace, IWordContext context) {
        if (StringUtils.isEmpty((String)target)) {
            return target;
        }
        return this.replaceSensitiveWord(target, replace, context);
    }

    private List<IWordResult> getSensitiveWords(String text, ValidModeEnum modeEnum, IWordContext context) {
        if (StringUtils.isEmpty((String)text)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        for (int i = 0; i < text.length(); ++i) {
            SensitiveCheckResult checkResult = this.sensitiveCheck(text, i, ValidModeEnum.FAIL_OVER, context);
            int wordLength = checkResult.index();
            if (wordLength <= 0) continue;
            String sensitiveWord = text.substring(i, i + wordLength);
            WordResult wordResult = WordResult.newInstance().startIndex(i).endIndex(i + wordLength).word(sensitiveWord);
            resultList.add(wordResult);
            if (ValidModeEnum.FAIL_FAST.equals((Object)modeEnum)) break;
            i += wordLength - 1;
        }
        return resultList;
    }

    private String replaceSensitiveWord(String target, ISensitiveWordReplace replace, IWordContext context) {
        if (StringUtils.isEmpty((String)target)) {
            return target;
        }
        StringBuilder resultBuilder = new StringBuilder(target.length());
        for (int i = 0; i < target.length(); ++i) {
            char currentChar = target.charAt(i);
            SensitiveCheckResult checkResult = this.sensitiveCheck(target, i, ValidModeEnum.FAIL_OVER, context);
            int wordLength = checkResult.index();
            if (wordLength > 0) {
                Class<? extends ISensitiveCheck> checkClass = checkResult.checkClass();
                String string = target.substring(i, i + wordLength);
                if (SensitiveCheckUrl.class.equals(checkClass) && FileUtils.isImage((String)string)) {
                    resultBuilder.append(string);
                } else {
                    SensitiveWordReplaceContext replaceContext = SensitiveWordReplaceContext.newInstance().sensitiveWord(string).wordLength(wordLength);
                    String replaceStr = replace.replace(replaceContext);
                    resultBuilder.append(replaceStr);
                }
                i += wordLength - 1;
                continue;
            }
            resultBuilder.append(currentChar);
        }
        return resultBuilder.toString();
    }

    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        context.sensitiveWordMap(this.innerWordMap);
        return ((SensitiveCheckChain)Instances.singleton(SensitiveCheckChain.class)).sensitiveCheck(txt, beginIndex, validModeEnum, context);
    }
}

