/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sentinel.configuration;

import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sentinel.configuration.SentinelAutoConfiguration;
import com.taotao.cloud.sentinel.enhance.CustomSentinelFeign;
import com.taotao.cloud.sentinel.properties.SentinelCloudProperties;
import feign.Feign;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

@AutoConfiguration(before={SentinelFeignAutoConfiguration.class}, after={SentinelAutoConfiguration.class})
@EnableConfigurationProperties(value={SentinelCloudProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.alibaba.sentinel", name={"enabled"}, havingValue="true")
public class SentinelCloudAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SentinelCloudAutoConfiguration.class, (String)"taotao-cloud-starter-sentinel", (String[])new String[0]);
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"feign.sentinel.enabled"})
    public Feign.Builder feignSentinelBuilder() {
        return CustomSentinelFeign.builder();
    }
}

