/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.advice;

import com.alibaba.fastjson2.JSON;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.annotation.DecryptBody;
import com.taotao.cloud.sign.bean.DecryptAnnotationInfoBean;
import com.taotao.cloud.sign.bean.DecryptHttpInputMessage;
import com.taotao.cloud.sign.enums.DecryptBodyMethod;
import com.taotao.cloud.sign.exception.DecryptDtguaiException;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@Order(value=1)
@RestControllerAdvice(basePackages={"com.taotao.cloud.*.biz.api.controller"})
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private final EncryptBodyProperties config;

    public DecryptRequestBodyAdvice(EncryptBodyProperties config) {
        this.config = config;
    }

    public boolean supports(MethodParameter methodParameter, @NotNull Type targetType, @NotNull Class<? extends HttpMessageConverter<?>> converterType) {
        Annotation[] annotations = methodParameter.getDeclaringClass().getAnnotations();
        if (Arrays.stream(annotations).anyMatch(DecryptBody.class::isInstance)) {
            return true;
        }
        return Optional.of(methodParameter).map(MethodParameter::getMethod).map(x -> x.isAnnotationPresent(DecryptBody.class)).orElseThrow(() -> new DecryptDtguaiException("\u89e3\u5bc6\u62e6\u622a\u5668\u8fd4\u56de\u5f02\u5e38"));
    }

    public Object handleEmptyBody(Object body, @NotNull HttpInputMessage inputMessage, @NotNull MethodParameter parameter, @NotNull Type targetType, @NotNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    @NotNull
    public HttpInputMessage beforeBodyRead(@NotNull HttpInputMessage inputMessage, @NotNull MethodParameter parameter, @NotNull Type targetType, @NotNull Class<? extends HttpMessageConverter<?>> converterType) {
        String sign;
        LinkedHashMap req;
        String body;
        if (Optional.of(inputMessage).map(x -> {
            try {
                return x.getBody();
            }
            catch (IOException e) {
                LogUtils.error((String)"\u6570\u636e\u89e3\u5bc6\u521d\u59cb\u5316\u5f02\u5e38,\u65f6\u95f4:{}", (Object[])new Object[]{new Date()});
                return null;
            }
        }).isEmpty()) {
            return inputMessage;
        }
        try {
            body = IOUtils.toString((InputStream)inputMessage.getBody(), (String)this.config.getEncoding());
            req = (LinkedHashMap)JSON.parseObject((String)body, LinkedHashMap.class);
            body = (String)req.get("dataSecret");
            sign = (String)req.get("sign");
        }
        catch (Exception e) {
            LogUtils.error((String)"\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u6b63\u6587\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u6570\u636e\u4f53\u6216\u8bf7\u6c42\u65b9\u6cd5\u662f\u5426\u7b26\u5408\u89c4\u8303", (Object[])new Object[]{e});
            throw new DecryptDtguaiException("\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u6b63\u6587\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u6570\u636e\u4f53\u6216\u8bf7\u6c42\u65b9\u6cd5\u662f\u5426\u7b26\u5408\u89c4\u8303");
        }
        if (!StringUtils.hasText((String)body)) {
            LogUtils.error((String)"\u8bf7\u6c42\u53c2\u6570dataSecret\u4e3anull\u6216\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff0c\u56e0\u6b64\u89e3\u5bc6\u5931\u8d25body:{}", (Object[])new Object[]{body});
            throw new DecryptDtguaiException("\u8bf7\u6c42\u6b63\u6587\u4e3aNULL\u6216\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff0c\u56e0\u6b64\u89e3\u5bc6\u5931\u8d25");
        }
        String decryptBody = null;
        DecryptAnnotationInfoBean methodAnnotation = this.getMethodAnnotation(parameter);
        if (methodAnnotation != null) {
            decryptBody = this.switchDecrypt(body, methodAnnotation);
        } else {
            DecryptAnnotationInfoBean classAnnotation = this.getClassAnnotation(parameter.getDeclaringClass());
            if (classAnnotation != null) {
                decryptBody = this.switchDecrypt(body, classAnnotation);
            }
        }
        decryptBody = Optional.ofNullable(decryptBody).orElseThrow(() -> {
            LogUtils.error((String)"decryptBody\u662fnull\u5f53\u524d\u7c7b:{}", (Object[])new Object[]{this.getClass().getName()});
            return new DecryptDtguaiException("\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u9009\u62e9\u7684\u6e90\u6570\u636e\u7684\u52a0\u5bc6\u65b9\u5f0f\u662f\u5426\u6b63\u786e");
        });
        try {
            req = (LinkedHashMap)JSON.parseObject((String)decryptBody, LinkedHashMap.class);
            req.put("sign", sign);
            LogUtils.info((String)"\u89e3\u5bc6\u6570\u636e\u8865\u5145timestamp\u548csign\u7684map:{}", (Object[])new Object[]{JSON.toJSONString((Object)req)});
            InputStream inputStream = IOUtils.toInputStream((String)JSON.toJSONString((Object)req), (String)this.config.getEncoding());
            return new DecryptHttpInputMessage(inputStream, inputMessage.getHeaders());
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u6d41\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u7b49\u683c\u5f0f\u662f\u5426\u6b63\u786e,decryptBody:{}", (Object[])new Object[]{decryptBody});
            throw new DecryptDtguaiException("\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u6d41\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u7b49\u683c\u5f0f\u662f\u5426\u6b63\u786e,decryptBody:" + decryptBody);
        }
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    private DecryptAnnotationInfoBean getMethodAnnotation(MethodParameter methodParameter) {
        boolean annotation = Optional.ofNullable(methodParameter).map(MethodParameter::getMethod).map(x -> x.isAnnotationPresent(DecryptBody.class)).orElse(false);
        if (annotation) {
            DecryptBody decryptBody = (DecryptBody)methodParameter.getMethodAnnotation(DecryptBody.class);
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(Optional.ofNullable(decryptBody).map(DecryptBody::value).orElse(null)).key(Optional.ofNullable(decryptBody).map(DecryptBody::otherKey).orElse(null)).timeOut(Optional.ofNullable(decryptBody).map(DecryptBody::timeOut).orElse(0L)).build();
        }
        return null;
    }

    private DecryptAnnotationInfoBean getClassAnnotation(Class<?> clazz) {
        Annotation[] annotations = clazz.getDeclaredAnnotations();
        return Optional.of(annotations).map(x -> {
            for (Annotation annotation : x) {
                if (!(annotation instanceof DecryptBody)) continue;
                DecryptBody decryptBody = (DecryptBody)annotation;
                return DecryptAnnotationInfoBean.builder().decryptBodyMethod(decryptBody.value()).key(decryptBody.otherKey()).build();
            }
            return null;
        }).orElse(null);
    }

    private String switchDecrypt(String formatStringBody, DecryptAnnotationInfoBean infoBean) {
        DecryptBodyMethod method = Optional.ofNullable(infoBean.getDecryptBodyMethod()).orElseThrow(() -> new DecryptDtguaiException("\u89e3\u5bc6\u65b9\u5f0f\u672a\u5b9a\u4e49"));
        String decodeData = method.getSecurity().decrypt(formatStringBody, infoBean.getKey(), this.config);
        this.verifyTime(decodeData, infoBean.getTimeOut());
        return decodeData;
    }

    private void verifyTime(String decodeData, long timeOut) {
        long nowTime;
        long timestamp;
        if (0L != timeOut && (timestamp = Optional.ofNullable(decodeData).map(x -> (Map)JSON.parseObject((String)x, Map.class)).map(x -> x.get("timestamp")).map(x -> Long.parseLong(x.toString())).orElseThrow(() -> new DecryptDtguaiException("\u6570\u636e\u52a0\u5bc6timestamp\u4e0d\u80fd\u4e3a\u7a7a")).longValue()) + timeOut < (nowTime = System.currentTimeMillis())) {
            LogUtils.error((String)"\u65f6\u95f4\u6233:{},\u65f6\u95f4\u6233+\u8fc7\u671f\u65f6\u95f4:{},\u5f53\u524d\u65f6\u95f4:{},\u65f6\u95f4\u5dee:{},\u6570\u636e\u4e3a:{}", (Object[])new Object[]{timestamp, timestamp + timeOut, nowTime, timestamp + timeOut - nowTime, decodeData});
            throw new DecryptDtguaiException("\u89e3\u5bc6\u6570\u636e\u8fc7\u671f,\u63d0\u4ea4\u5931\u8d25");
        }
    }
}

