/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.advice;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.annotation.EncryptBody;
import com.taotao.cloud.sign.bean.EncryptAnnotationInfoBean;
import com.taotao.cloud.sign.enums.EncryptBodyMethod;
import com.taotao.cloud.sign.exception.DecryptDtguaiException;
import com.taotao.cloud.sign.exception.EncryptDtguaiException;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.properties.EncryptProperties;
import com.taotao.cloud.sign.util.CheckUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=1)
@RestControllerAdvice(basePackages={"com.taotao.cloud.*.biz.api.controller"})
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private final ObjectMapper objectMapper;
    private final EncryptBodyProperties config;
    private final EncryptProperties encryptProperties;

    @Autowired
    public EncryptResponseBodyAdvice(ObjectMapper objectMapper, EncryptBodyProperties config, EncryptProperties encryptProperties) {
        this.objectMapper = objectMapper;
        this.config = config;
        this.encryptProperties = encryptProperties;
    }

    public boolean supports(MethodParameter returnType, Class converterType) {
        Annotation[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (Arrays.stream(annotations).anyMatch(EncryptBody.class::isInstance)) {
            return true;
        }
        return Optional.of(returnType).map(MethodParameter::getMethod).map(x -> x.isAnnotationPresent(EncryptBody.class)).orElseThrow(() -> new DecryptDtguaiException("\u52a0\u5bc6\u62e6\u622a\u5668\u8fd4\u56de\u5f02\u5e38"));
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String encryptStr;
        if (body == null) {
            return null;
        }
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        String result = null;
        Map repMap = null;
        EncryptAnnotationInfoBean methodAnnotation = this.getMethodAnnotation(returnType);
        EncryptAnnotationInfoBean classAnnotation = this.getClassAnnotation(returnType.getDeclaringClass());
        String dataName = Optional.ofNullable(methodAnnotation).map(EncryptAnnotationInfoBean::getEncryptMsgName).orElse(Optional.ofNullable(classAnnotation).map(EncryptAnnotationInfoBean::getEncryptMsgName).orElse(null));
        try {
            String str = this.objectMapper.writeValueAsString(body);
            repMap = Optional.ofNullable(str).map(x -> (Map)JSON.parseObject((String)x, Map.class)).orElse(null);
            result = Optional.ofNullable(repMap).map(x -> x.get(dataName)).map(Object::toString).orElse(null);
        }
        catch (JsonProcessingException e) {
            LogUtils.error((String)"\u54cd\u5e94\u6570\u636e\u7684\u52a0\u5bc6\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[]{e});
        }
        if (methodAnnotation != null && result != null) {
            encryptStr = this.switchEncrypt(result, methodAnnotation);
        } else if (classAnnotation != null && result != null) {
            encryptStr = this.switchEncrypt(result, classAnnotation);
        } else {
            LogUtils.error((String)"EncryptResponseBodyAdvice \u52a0\u5bc6\u6570\u636e\u5931\u8d25 body:{}", (Object[])new Object[]{body});
            encryptStr = null;
        }
        Optional.ofNullable(repMap).ifPresent(x -> x.put(dataName, encryptStr));
        return repMap;
    }

    private EncryptAnnotationInfoBean getMethodAnnotation(MethodParameter methodParameter) {
        Method method = Optional.ofNullable(methodParameter).map(MethodParameter::getMethod).orElseThrow(() -> {
            LogUtils.error((String)"\u83b7\u53d6\u65b9\u6cd5\u63a7\u5236\u5668\u4e0a\u7684\u52a0\u5bc6\u6ce8\u89e3\u4fe1\u606f,\u4e3anull--methodParameter:{}", (Object[])new Object[]{methodParameter});
            return new EncryptDtguaiException("\u83b7\u53d6\u65b9\u6cd5\u63a7\u5236\u5668\u4e0a\u7684\u52a0\u5bc6\u6ce8\u89e3\u4fe1\u606f,\u4e3anull");
        });
        EncryptBody encryptBody = (EncryptBody)methodParameter.getMethodAnnotation(EncryptBody.class);
        if (method.isAnnotationPresent(EncryptBody.class) && encryptBody != null) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(encryptBody.value()).key(encryptBody.otherKey()).shaEncryptType(encryptBody.shaType()).encryptMsgName(CheckUtils.checkAndGetKey(this.encryptProperties.getResultName(), encryptBody.resultName(), "\u8fd4\u56de\u503c\u540d\u79f0")).build();
        }
        return null;
    }

    private EncryptAnnotationInfoBean getClassAnnotation(Class<?> clazz) {
        Annotation[] annotations = clazz.getDeclaredAnnotations();
        return Optional.of(annotations).map(x -> {
            for (Annotation annotation : x) {
                if (!(annotation instanceof EncryptBody)) continue;
                EncryptBody encryptBody = (EncryptBody)annotation;
                return EncryptAnnotationInfoBean.builder().encryptBodyMethod(encryptBody.value()).key(encryptBody.otherKey()).shaEncryptType(encryptBody.shaType()).build();
            }
            return null;
        }).orElse(null);
    }

    private String switchEncrypt(String formatStringBody, EncryptAnnotationInfoBean infoBean) {
        EncryptBodyMethod method = Optional.ofNullable(infoBean.getEncryptBodyMethod()).orElseThrow(() -> new DecryptDtguaiException("\u52a0\u5bc6\u65b9\u5f0f\u672a\u5b9a\u4e49"));
        if (method == EncryptBodyMethod.SHA) {
            return method.getiSecurity().encrypt(formatStringBody, infoBean.getShaEncryptType().getValue(), this.config);
        }
        return method.getiSecurity().encrypt(formatStringBody, infoBean.getKey(), this.config);
    }
}

