/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.advice;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.exception.SignDtguaiException;
import com.taotao.cloud.sign.properties.SignProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class SignAspect {
    private final SignProperties signProperties;
    public static final String TOKEN_HEADER = "token";
    public static final String SIGN_HEADER = "sign";
    public static final String DATA_SECRET_HEADER = "dataSecret";

    public SignAspect(SignProperties signProperties) {
        this.signProperties = signProperties;
    }

    @Pointcut(value="@annotation(com.taotao.cloud.sign.annotation.Sign)")
    public void signPointCut() {
    }

    @Around(value="signPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        TreeMap reqm = Optional.ofNullable(args[0]).map(x -> JSON.toJSONString((Object)x, (String)"yyyy-MM-dd HH:mm:ss", (JSONWriter.Feature[])new JSONWriter.Feature[0])).map(x -> (TreeMap)JSON.parseObject((String)x, TreeMap.class)).orElseThrow(() -> new SignDtguaiException("sing\u6ce8\u89e3\u4e2d\u52a0\u5bc6\u6570\u636e\u4e3a\u7a7a"));
        String timestamp = Optional.ofNullable(reqm.get("timestamp")).map(Object::toString).orElseThrow(() -> new SignDtguaiException("\u6570\u5b57\u8bc1\u4e66timestamp\u4e0d\u80fd\u4e3a\u7a7a"));
        LogUtils.info((String)"sign\u7684TreeMap\u9ed8\u8ba4key\u5347\u5e8f\u6392\u5e8ftimestamp:{} ---- json:{}", (Object[])new Object[]{timestamp, JSON.toJSONString((Object)reqm)});
        Optional.of(reqm).ifPresent(this::validSign);
        return point.proceed();
    }

    private void validSign(Map<String, Object> reqm) {
        String md5Sign;
        String sign;
        StringBuilder paramBuilder = new StringBuilder();
        try {
            reqm = Optional.ofNullable(reqm).orElseThrow(() -> new SignDtguaiException("sign\u7684map\u4e0d\u80fd\u4e3a\u7a7a"));
            sign = Optional.ofNullable(reqm).map(x -> x.get(SIGN_HEADER)).map(Object::toString).orElseThrow(() -> new SignDtguaiException("sign\u4e0d\u80fd\u4e3a\u7a7a"));
            reqm.forEach((k, v) -> {
                List<String> ignore = this.signProperties.getIgnore();
                if (v != null && !ignore.contains(k)) {
                    paramBuilder.append((String)k).append("=").append(v).append("&");
                }
            });
            String dataSing = paramBuilder.append("signKey=").append(this.signProperties.getKey()).toString();
            LogUtils.info((String)"sing\u4e4b\u524d\u7684\u62fc\u88c5\u6570\u636e:{}", (Object[])new Object[]{dataSing});
            md5Sign = DigestUtils.md5Hex((String)dataSing);
        }
        catch (Exception e) {
            LogUtils.error((String)"sign\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u51fa\u9519{}", (Object[])new Object[]{reqm, e});
            throw new SignDtguaiException("sign\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u51fa\u9519");
        }
        if (!md5Sign.equals(sign)) {
            LogUtils.error((String)"\u9a8c\u8bc1\u5931\u8d25:{}  \u4f20\u5165\u7684sign:{}  \u5f53\u524d\u751f\u6210\u7684md5Sign:{}", (Object[])new Object[]{paramBuilder, sign, md5Sign});
            throw new SignDtguaiException("\u6570\u5b57\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25");
        }
    }
}

