/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.advice.DecryptRequestBodyAdvice;
import com.taotao.cloud.sign.advice.EncryptResponseBodyAdvice;
import com.taotao.cloud.sign.advice.SignAspect;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.properties.EncryptProperties;
import com.taotao.cloud.sign.properties.SignProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.sign", name={"enabled"}, havingValue="true")
@Import(value={EncryptResponseBodyAdvice.class, DecryptRequestBodyAdvice.class, SignAspect.class})
@EnableConfigurationProperties(value={EncryptBodyProperties.class, EncryptProperties.class, SignProperties.class})
public class SignAutoConfiguration
implements WebMvcConfigurer,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SignAutoConfiguration.class, (String)"taotao-cloud-starter-sign", (String[])new String[0]);
    }

    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(){

            protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException {
                if (object instanceof String) {
                    Charset charset = this.getDefaultCharset();
                    assert (charset != null);
                    StreamUtils.copy((String)((String)object), (Charset)charset, (OutputStream)outputMessage.getBody());
                } else {
                    super.writeInternal(object, type, outputMessage);
                }
            }
        };
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter converter = this.mappingJackson2HttpMessageConverter();
        LinkedList<MediaType> mediaTypes = new LinkedList<MediaType>();
        mediaTypes.add(MediaType.TEXT_HTML);
        mediaTypes.add(MediaType.APPLICATION_JSON);
        converter.setSupportedMediaTypes(mediaTypes);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)converter);
    }
}

