/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.exception.DecryptDtguaiException;
import com.taotao.cloud.sign.exception.EncryptDtguaiException;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.util.CheckUtils;
import com.taotao.cloud.sign.util.ISecurity;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil
implements ISecurity {
    private static final String AES = "AES";
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final int KEY_LENGTH = 16;

    public static SecretKey getKey(String password) {
        byte[] passwordBytes = Optional.ofNullable(password).map(String::getBytes).orElseThrow(() -> new DecryptDtguaiException("aes\u52a0\u89e3\u5bc6getKey\u5f02\u5e38password:{}" + password));
        if (passwordBytes.length != 16 && passwordBytes.length != 32) {
            LogUtils.error((String)"aes\u94a5\u5319\u957f\u5ea6\u4e3a16\u621632,passwordBytes.length:{}", (Object[])new Object[]{passwordBytes.length});
            throw new DecryptDtguaiException("aes\u94a5\u5319\u957f\u5ea6\u4e3a16\u621632");
        }
        return new SecretKeySpec(passwordBytes, AES);
    }

    @Override
    public String encrypt(String content, String password, EncryptBodyProperties config) {
        byte[] ciphertext;
        SecretKey key = AesUtil.getKey(CheckUtils.checkAndGetKey(config.getAesKey(), password, "AES-KEY\u52a0\u5bc6"));
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance(config.getAesCipherAlgorithm());
            cipher.init(1, (Key)key, ivSpec);
            ciphertext = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LogUtils.error((String)"aes\u52a0\u5bc6\u5f02\u5e38,e:{}", (Object[])new Object[]{e.getMessage()});
            throw new EncryptDtguaiException("aes\u52a0\u5bc6\u5f02\u5e38");
        }
        byte[] encrypted = new byte[iv.length + ciphertext.length];
        System.arraycopy(iv, 0, encrypted, 0, iv.length);
        System.arraycopy(ciphertext, 0, encrypted, iv.length, ciphertext.length);
        return Base64.getEncoder().encodeToString(encrypted);
    }

    @Override
    public String decrypt(String content, String password, EncryptBodyProperties config) {
        byte[] ciphertext;
        SecretKey key = AesUtil.getKey(CheckUtils.checkAndGetKey(config.getAesKey(), password, "AES-KEY\u89e3\u5bc6"));
        byte[] decoded = Base64.getDecoder().decode(content);
        byte[] iv = Arrays.copyOfRange(decoded, 0, 12);
        GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance(config.getAesCipherAlgorithm());
            cipher.init(2, (Key)key, ivSpec);
            ciphertext = cipher.doFinal(decoded, 12, decoded.length - 12);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LogUtils.error((String)"aes\u89e3\u5bc6\u5f02\u5e38,e:{}", (Object[])new Object[]{e.getMessage()});
            throw new DecryptDtguaiException("aes\u89e3\u5bc6\u5f02\u5e38");
        }
        return new String(ciphertext, StandardCharsets.UTF_8);
    }
}

