/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.exception.EncryptDtguaiException;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.util.CheckUtils;
import com.taotao.cloud.sign.util.ISecurity;
import com.taotao.cloud.sign.util.security.Hex2Util;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DesUtil
implements ISecurity {
    private static final String DES = "DES";

    private static String des(String content, String password, int type, String cipherAlgorithm) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(type, (Key)keyFactory.generateSecret(desKey), random);
            return DesUtil.encryptMode(content, type, cipher);
        }
        catch (Exception e) {
            LogUtils.error((String)"des\u89e3\u5bc6\u5f02\u5e38content:{},password:{},type:{},cipherAlgorithm:{},e:{}", (Object[])new Object[]{content, password, type, cipherAlgorithm, e.getMessage()});
            throw new EncryptDtguaiException("des\u89e3\u5bc6\u5f02\u5e38");
        }
    }

    public static String encryptMode(String content, int type, Cipher cipher) throws BadPaddingException, IllegalBlockSizeException {
        if (type == 1) {
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            return Hex2Util.parseByte2HexStr(cipher.doFinal(byteContent));
        }
        byte[] byteContent = Hex2Util.parseHexStr2Byte(content);
        return new String(cipher.doFinal(byteContent));
    }

    @Override
    public String encrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getDesKey(), password, "DES-KEY\u52a0\u5bc6");
        return DesUtil.des(content, key, 1, config.getDesCipherAlgorithm());
    }

    @Override
    public String decrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getDesKey(), password, "DES-KEY\u89e3\u5bc6");
        return DesUtil.des(content, key, 2, config.getDesCipherAlgorithm());
    }
}

