/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.enums.SHAEncryptType;
import com.taotao.cloud.sign.exception.EncryptDtguaiException;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.util.ISecurity;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class ShaUtil
implements ISecurity {
    @Override
    public String encrypt(String content, String password, EncryptBodyProperties config) {
        if (!StringUtils.hasText((String)content)) {
            return "";
        }
        password = Optional.ofNullable(password).orElse(SHAEncryptType.SHA256.getValue());
        try {
            MessageDigest md5 = MessageDigest.getInstance(password);
            byte[] bytes = md5.digest(content.getBytes());
            StringBuilder result = new StringBuilder();
            for (byte b : bytes) {
                Object temp = Integer.toHexString(b & 0xFF);
                if (((String)temp).length() == 1) {
                    temp = "0" + (String)temp;
                }
                result.append((String)temp);
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.error((String)"ShaEncryptUtil->encrypt \u5f02\u5e38,string:{},type:{}", (Object[])new Object[]{password, password});
            throw new EncryptDtguaiException("ShaEncryptUtil->encrypt \u5f02\u5e38");
        }
    }

    @Override
    public String decrypt(String content, String password, EncryptBodyProperties config) {
        LogUtils.error((String)"SHA\u6458\u8981\u52a0\u5bc6,\u65e0\u6cd5\u89e3\u5bc6", (Object[])new Object[0]);
        throw new EncryptDtguaiException("SHA\u6458\u8981\u52a0\u5bc6,\u65e0\u6cd5\u89e3\u5bc6");
    }
}

