/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security.rsa;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.exception.EncryptDtguaiException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InitKey {
    public static final String PUBLIC_KEY = "pub";
    public static final String PRIVATE_KEY = "pri";

    public static Map<String, Object> initKey(String rsaKey) {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.error((String)"rsa\u521d\u59cb\u5316\u5bc6\u94a5\u5bf9\u5f02\u5e38", (Object[])new Object[]{e});
            throw new EncryptDtguaiException("rsa\u521d\u59cb\u5316\u5bc6\u94a5\u5bf9\u5f02\u5e38");
        }
        SecureRandom secureRandom = new SecureRandom(Optional.ofNullable(rsaKey).map(String::getBytes).orElseThrow(() -> new EncryptDtguaiException("rsa\u79d8\u94a5\u521d\u59cb\u5316\u5931\u8d25,rsaKey:" + rsaKey)));
        keyPairGenerator.initialize(2048, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(4);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static byte[] getPrivateKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return key.getEncoded();
    }

    public static byte[] getPublicKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return key.getEncoded();
    }
}

