/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security.rsa;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.sign.exception.EncryptDtguaiException;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.util.CheckUtils;
import com.taotao.cloud.sign.util.ISecurity;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Optional;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaUtil
implements ISecurity {
    public static final String KEY_ALGORITHM = "RSA";
    public static final int KEY_SIZE = 2048;
    private static final int DATA_MAX_SIZE = 245;

    public static byte[] encryptByPublicKey(byte[] data, byte[] key) {
        Optional.ofNullable(data).map(x -> ((byte[])x).length).ifPresent(x -> {
            if (x > 245) {
                throw new EncryptDtguaiException("\u516c\u94a5\u52a0\u5bc6\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c:245");
            }
        });
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, pubKey);
            return cipher.doFinal(Optional.ofNullable(data).orElseThrow(() -> new EncryptDtguaiException("\u5f85\u52a0\u5bc6\u6570\u636e\u4e3anull")));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u516c\u94a5\u52a0\u5bc6\u51fa\u9519", (Object[])new Object[]{e});
            throw new EncryptDtguaiException("\u516c\u94a5\u52a0\u5bc6\u51fa\u9519");
        }
    }

    public static byte[] decryptByPublicKey(byte[] data, byte[] key) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, pubKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u516c\u94a5\u89e3\u5bc6\u51fa\u9519", (Object[])new Object[]{e});
            throw new EncryptDtguaiException("\u516c\u94a5\u89e3\u5bc6\u51fa\u9519");
        }
    }

    public static byte[] decryptByPrivateKey(byte[] data, byte[] key) {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519", (Object[])new Object[]{e});
            throw new EncryptDtguaiException("\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519");
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] key) {
        Optional.ofNullable(data).map(x -> ((byte[])x).length).ifPresent(x -> {
            if (x > 245) {
                throw new EncryptDtguaiException("\u79c1\u94a5\u52a0\u5bc6\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c:245");
            }
        });
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            return null != data ? cipher.doFinal(data) : null;
        }
        catch (Exception e) {
            LogUtils.error((String)"\u79c1\u94a5\u52a0\u5bc6\u51fa\u9519", (Object[])new Object[]{e});
            throw new EncryptDtguaiException("\u79c1\u94a5\u52a0\u5bc6\u51fa\u9519");
        }
    }

    @Override
    public String encrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getRsaPirKey(), password, "RSA-KEY\u52a0\u5bc6");
        return Optional.ofNullable(RsaUtil.encryptByPrivateKey(content.getBytes(), Base64.decodeBase64((String)key))).map(Base64::encodeBase64String).orElse(null);
    }

    @Override
    public String decrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getRsaPirKey(), password, "RSA-KEY\u89e3\u5bc6");
        return Optional.ofNullable(RsaUtil.decryptByPrivateKey(Base64.decodeBase64((String)content), Base64.decodeBase64((String)key))).map(String::new).orElse(null);
    }
}

