/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security.sm;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.util.CheckUtils;
import com.taotao.cloud.sign.util.ISecurity;

public class Sm2Util
implements ISecurity {
    @Override
    public String encrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getSm2PubKey(), password, "SM2-KEY-\u5bf9\u65b9\u516c\u94a5-\u52a0\u5bc6");
        return SmUtil.sm2(null, (String)key).encryptBcd(content, KeyType.PublicKey);
    }

    @Override
    public String decrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getSm2PirKey(), password, "SM2-KEY\u89e3\u5bc6");
        return StrUtil.utf8Str((Object)SmUtil.sm2((String)key, null).decryptFromBcd(content, KeyType.PrivateKey));
    }
}

