/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.sign.util.security.sm;

import cn.hutool.crypto.SmUtil;
import com.taotao.cloud.sign.properties.EncryptBodyProperties;
import com.taotao.cloud.sign.util.CheckUtils;
import com.taotao.cloud.sign.util.ISecurity;

public class Sm4Util
implements ISecurity {
    @Override
    public String encrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getSm4Key(), password, "RSA-KEY\u52a0\u5bc6");
        return SmUtil.sm4((byte[])key.getBytes()).encryptHex(content);
    }

    @Override
    public String decrypt(String content, String password, EncryptBodyProperties config) {
        String key = CheckUtils.checkAndGetKey(config.getSm4Key(), password, "SM4-KEY\u89e3\u5bc6");
        return SmUtil.sm4((byte[])key.getBytes()).decryptStr(content);
    }
}

