/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.threadpool.configuration;

import com.dtp.common.em.QueueTypeEnum;
import com.dtp.core.spring.EnableDynamicTp;
import com.dtp.core.support.DynamicTp;
import com.dtp.core.support.ThreadPoolBuilder;
import com.dtp.core.support.ThreadPoolCreator;
import com.dtp.core.thread.DtpExecutor;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.threadpool.properties.ThreadPoolProperties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableDynamicTp
@ConditionalOnProperty(prefix="taotao.cloud.threadpool", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
public class DynamicTpAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DynamicTpAutoConfiguration.class, (String)"taotao-cloud-starter-threadpool", (String[])new String[0]);
    }

    @DynamicTp(value="commonExecutor")
    @Bean
    public ThreadPoolExecutor commonExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    @Bean
    public DtpExecutor dtpExecutor1() {
        return ThreadPoolCreator.createDynamicFast((String)"dtpExecutor1");
    }

    @Bean
    public DtpExecutor ioIntensiveExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("ioIntensiveExecutor").corePoolSize(20).maximumPoolSize(50).queueCapacity(2048).ioIntensive(true).buildDynamic();
    }

    @Bean
    public ThreadPoolExecutor dtpExecutor2() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("dtpExecutor2").corePoolSize(10).maximumPoolSize(15).keepAliveTime(50L).timeUnit(TimeUnit.MILLISECONDS).workQueue(QueueTypeEnum.SYNCHRONOUS_QUEUE.getName(), null, Boolean.valueOf(false)).waitForTasksToCompleteOnShutdown(true).awaitTerminationSeconds(5).buildDynamic();
    }
}

