/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.tracing.skywalking.interceptor;

import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.tracing.skywalking.ClusterTrace;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class TraceInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceInterceptor.class);
    public static final String TRACE_ID_HEADER = "Trace-Id";
    private final ClusterTrace clusterTrace;
    private static final String ERROR_STR = "Ignored_Trace,N/A";

    public TraceInterceptor(ClusterTrace clusterTrace) {
        this.clusterTrace = clusterTrace;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceId;
        String string = traceId = response.getHeader(TRACE_ID_HEADER) != null ? response.getHeader(TRACE_ID_HEADER) : "";
        if (!StringUtils.hasLength((String)traceId)) {
            traceId = TraceContext.traceId();
        }
        if (!StringUtils.hasLength((String)traceId) || ERROR_STR.contains(traceId)) {
            traceId = IdGeneratorUtils.getIdStr();
        }
        response.setHeader(TRACE_ID_HEADER, traceId);
        MDC.put((String)"tid", (String)traceId);
        this.clusterTrace.setTraceId(traceId);
        LOGGER.info("Trace-Id:{},PATH:{}", (Object)traceId, (Object)request.getRequestURI());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        MDC.remove((String)"tid");
        this.clusterTrace.removeTraceId();
    }
}

