/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.aop;

import com.google.common.base.Stopwatch;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.web.annotation.CountTime;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CountTimeAop {
    @Around(value="@annotation(countTime)")
    public Object doAround(ProceedingJoinPoint pjp, CountTime countTime) throws Throwable {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object obj = pjp.proceed();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
        long elapsed = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
        LogUtils.info((String)"\u65b9\u6cd5 [{}] \u82b1\u8d39\u65f6\u95f4\uff1a{}ms", (Object[])new Object[]{methodName, elapsed});
        return obj;
    }
}

