/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.base.controller;

import cn.hutool.core.util.ReflectUtil;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.reflect.ReflectionUtils;
import com.taotao.cloud.web.base.controller.BaseController;
import com.taotao.cloud.web.base.dto.BatchDTO;
import com.taotao.cloud.web.base.entity.SuperEntity;
import com.taotao.cloud.web.request.annotation.RequestLogger;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface BaseBatchController<T extends SuperEntity<T, I>, I extends Serializable, SaveDTO, UpdateDTO>
extends BaseController<T, I> {
    @Operation(summary="\u901a\u7528\u6279\u91cf\u64cd\u4f5c", description="\u901a\u7528\u6279\u91cf\u64cd\u4f5c")
    @PostMapping(value={"/batch"})
    @RequestLogger(value="\u901a\u7528\u6279\u91cf\u64cd\u4f5c")
    @PreAuthorize(value="@pms.hasPermission('batch')")
    default public Result<Boolean> batch(@Parameter(description="\u901a\u7528\u6279\u91cf\u64cd\u4f5c", required=true) @RequestBody @Validated BatchDTO<SaveDTO, UpdateDTO, I> batchDTO) {
        String method;
        return switch (method = batchDTO.method()) {
            case "create" -> this.success(this.batchCreate(batchDTO.batchCreate()));
            case "update" -> this.success(this.batchUpdate(batchDTO.batchUpdate()));
            case "delete" -> this.success(this.batchDelete(batchDTO.batchDelete()));
            default -> throw new BusinessException("\u64cd\u4f5c\u65b9\u5f0f\u9519\u8bef");
        };
    }

    default public Boolean batchCreate(List<SaveDTO> saveDTOList) {
        if (saveDTOList.isEmpty()) {
            throw new BusinessException("\u6dfb\u52a0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SuperEntity> entityList = saveDTOList.stream().filter(saveDTO -> ReflectionUtils.checkField(saveDTO.getClass(), this.getEntityClass())).map(saveDTO -> {
            SuperEntity t = (SuperEntity)ReflectUtil.newInstanceIfPossible(this.getEntityClass());
            return (SuperEntity)ReflectionUtils.copyPropertiesIfRecord((Object)t, (Object)saveDTO);
        }).toList();
        return this.service().saveBatch(entityList);
    }

    default public Boolean batchUpdate(List<BatchDTO.BatchUpdate<UpdateDTO, I>> updateDTOList) {
        if (updateDTOList.isEmpty()) {
            throw new BusinessException("\u66f4\u65b0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap updateDTOMap = new HashMap();
        updateDTOList.forEach(updateDTO -> {
            Object id = updateDTO.id();
            Object updateDTO1 = updateDTO.updateDTO();
            updateDTOMap.put(id, updateDTO1);
        });
        List ids = updateDTOList.stream().map(BatchDTO.BatchUpdate::id).collect(Collectors.toList());
        List ts = this.service().listByIds(ids);
        if (ts.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        List<SuperEntity> entityList = ts.stream().filter(updateDTO -> ReflectionUtils.checkField(updateDTO.getClass(), this.getEntityClass())).map(t -> {
            Object updateDTO = updateDTOMap.get(t.getId());
            return (SuperEntity)ReflectionUtils.copyPropertiesIfRecord((Object)t, updateDTO);
        }).toList();
        return this.service().updateBatchById(entityList);
    }

    default public Boolean batchDelete(List<I> batchDelete) {
        if (batchDelete.isEmpty()) {
            throw new BusinessException("\u5220\u9664\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.service().removeByIds(batchDelete);
    }
}

