/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.base.controller;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.web.base.entity.SuperEntity;
import com.taotao.cloud.web.base.service.BaseSuperService;
import java.io.Serializable;

public interface BaseController<T extends SuperEntity<T, I>, I extends Serializable> {
    public Class<T> getEntityClass();

    public BaseSuperService<T, I> service();

    default public <R> Result<R> success(R data) {
        return Result.success(data);
    }

    default public Result<Boolean> success() {
        return Result.success((Object)true);
    }

    default public Result<String> fail(String msg) {
        return Result.fail((String)msg);
    }

    default public Result<String> fail(int code, String msg) {
        return Result.fail((String)msg, (int)code);
    }

    default public <R> Result<R> fail(BusinessException exception) {
        return Result.fail((Throwable)exception);
    }

    default public <R> Result<R> fail(Throwable throwable) {
        return Result.fail((Throwable)throwable);
    }

    default public <R> Result<R> validFail(String msg) {
        return Result.validFail((String)msg);
    }

    default public <R> Result<R> validFail(String msg, Object ... args) {
        return Result.validFail((String)msg, (Object[])args);
    }

    default public <R> Result<R> validFail(ResultEnum resultEnum) {
        return Result.validFail((ResultEnum)resultEnum);
    }

    default public Long getUserId() {
        return SecurityUtils.getUserId();
    }

    default public String getTenant() {
        return SecurityUtils.getTenant();
    }

    default public String getNickname() {
        return SecurityUtils.getCurrentUser().getNickname();
    }

    default public String getUsername() {
        return SecurityUtils.getUsername();
    }
}

