/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.base.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.reflect.ReflectionUtils;
import com.taotao.cloud.data.mybatisplus.query.conditions.Wraps;
import com.taotao.cloud.data.mybatisplus.query.conditions.query.QueryWrap;
import com.taotao.cloud.web.base.controller.BaseController;
import com.taotao.cloud.web.base.entity.SuperEntity;
import com.taotao.cloud.web.request.annotation.RequestLogger;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;

public interface BaseDeleteController<T extends SuperEntity<T, I>, I extends Serializable>
extends BaseController<T, I> {
    @Operation(summary="\u901a\u7528\u5355\u4f53id\u5220\u9664", description="\u901a\u7528\u5355\u4f53id\u5220\u9664")
    @DeleteMapping(value={"/{id:[0-9]*}"})
    @RequestLogger(value="\u901a\u7528\u5355\u4f53id\u5220\u9664")
    default public Result<Boolean> deleteById(@Parameter(description="id", required=true) @NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") I id) {
        if (this.handlerDeleteById(id).booleanValue()) {
            return this.success(this.service().removeById((Serializable)id));
        }
        throw new BusinessException(ResultEnum.ERROR);
    }

    default public Boolean handlerDeleteById(I id) {
        if (Objects.isNull(id)) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }

    @Operation(summary="\u901a\u7528\u5355\u4f53\u5b57\u6bb5\u5220\u9664", description="\u901a\u7528\u5355\u4f53\u5b57\u6bb5\u5220\u9664")
    @DeleteMapping(value={"/{filedName}/{filedValue}"})
    @RequestLogger(value="\u901a\u7528\u5355\u4f53\u5b57\u6bb5\u5220\u9664")
    default public Result<Boolean> deleteByFiled(@Parameter(description="\u5b57\u6bb5\u540d\u79f0", required=true) @NotEmpty(message="\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="filedName") @NotEmpty(message="\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String filedName, @Parameter(description="\u5b57\u6bb5\u503c", required=true) @NotNull(message="\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="filedValue") @NotNull(message="\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a") Object filedValue) {
        if (this.handlerDeleteByFiled(filedName, filedValue).booleanValue() && ReflectionUtils.checkField((String)filedName, this.getEntityClass()).booleanValue()) {
            QueryWrap wrapper = Wraps.q();
            wrapper.eq(StrUtil.toUnderlineCase((CharSequence)filedName), filedValue);
            return this.success(this.service().remove((Wrapper)wrapper));
        }
        throw new BusinessException(ResultEnum.ERROR);
    }

    default public Boolean handlerDeleteByFiled(String filedName, Object filedValue) {
        if (Objects.isNull(filedName) || Objects.isNull(filedValue)) {
            throw new BusinessException("\u5b57\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }
}

