/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.web.properties.FilterProperties;
import com.taotao.cloud.web.servlet.filter.TenantFilter;
import com.taotao.cloud.web.servlet.filter.TraceFilter;
import com.taotao.cloud.web.servlet.filter.VersionFilter;
import com.taotao.cloud.web.servlet.filter.WebContextFilter;
import com.taotao.cloud.web.servlet.listener.StandardServletContextListener;
import com.taotao.cloud.web.servlet.servlet.StandardAsyncServlet;
import com.taotao.cloud.web.servlet.servlet.StandardServlet;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.WebApplicationInitializer;

@AutoConfiguration
public class ServletAutoConfiguration
implements WebApplicationInitializer,
InitializingBean {
    @Autowired
    private FilterProperties filterProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ServletAutoConfiguration.class, (String)"taotao-cloud-starter-web", (String[])new String[0]);
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        LogUtils.info((String)"servletContext.getServerInfo=== {}", (Object[])new Object[]{servletContext.getServerInfo()});
    }

    @Bean
    public ServletRegistrationBean<StandardServlet> standardServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new StandardServlet());
        servletRegistrationBean.setLoadOnStartup(1);
        servletRegistrationBean.setAsyncSupported(true);
        servletRegistrationBean.setUrlMappings(List.of("/standardServlet"));
        LogUtils.info((String)"\u6ce8\u518cservlet\u6210\u529f\uff0c\u540d\u79f0: {}", (Object[])new Object[]{StandardServlet.class.getName()});
        return servletRegistrationBean;
    }

    @Bean
    public ServletRegistrationBean<StandardAsyncServlet> standardAsyncServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new StandardAsyncServlet());
        servletRegistrationBean.setLoadOnStartup(1);
        servletRegistrationBean.setAsyncSupported(true);
        servletRegistrationBean.setUrlMappings(List.of("/standardAsyncServlet"));
        LogUtils.info((String)"\u6ce8\u518cservlet\u6210\u529f\uff0c\u540d\u79f0: {}", (Object[])new Object[]{StandardAsyncServlet.class.getName()});
        return servletRegistrationBean;
    }

    @Bean
    public ServletListenerRegistrationBean<StandardServletContextListener> listenerServletListenerRegistrationBean() {
        ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean();
        bean.setListener((EventListener)((Object)new StandardServletContextListener()));
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.cloud.web.filter", name={"version"}, havingValue="true")
    public FilterRegistrationBean<VersionFilter> lbIsolationFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new VersionFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(VersionFilter.class.getName());
        registrationBean.setOrder(-2147483642);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.cloud.web.filter", name={"tenant"}, havingValue="true")
    public FilterRegistrationBean<TenantFilter> tenantFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TenantFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(TenantFilter.class.getName());
        registrationBean.setOrder(-2147483643);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<TraceFilter> traceFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TraceFilter(this.filterProperties));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(TraceFilter.class.getName());
        registrationBean.setOrder(-2147483644);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.cloud.web.filter", name={"webContext"}, havingValue="true")
    public FilterRegistrationBean<WebContextFilter> webContextFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new WebContextFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(WebContextFilter.class.getName());
        registrationBean.setOrder(-2147483645);
        return registrationBean;
    }
}

