/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.configuration;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.model.SecurityUser;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.core.configuration.AsyncAutoConfiguration;
import com.taotao.cloud.web.annotation.LoginUser;
import com.taotao.cloud.web.aop.CountTimeAop;
import com.taotao.cloud.web.interceptor.DoubtApiInterceptor;
import com.taotao.cloud.web.interceptor.HeaderThreadLocalInterceptor;
import com.taotao.cloud.web.listener.RequestMappingScanListener;
import com.taotao.cloud.web.properties.FilterProperties;
import com.taotao.cloud.web.properties.InterceptorProperties;
import com.taotao.cloud.web.validation.converter.IntegerToEnumConverterFactory;
import com.taotao.cloud.web.validation.converter.String2DateConverter;
import com.taotao.cloud.web.validation.converter.String2LocalDateConverter;
import com.taotao.cloud.web.validation.converter.String2LocalDateTimeConverter;
import com.taotao.cloud.web.validation.converter.String2LocalTimeConverter;
import com.taotao.cloud.web.validation.converter.StringToEnumConverterFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import okhttp3.OkHttpClient;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.TimeoutCallableProcessingInterceptor;
import org.springframework.web.context.request.async.TimeoutDeferredResultProcessingInterceptor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@AutoConfiguration
@EnableConfigurationProperties(value={FilterProperties.class, InterceptorProperties.class})
@Import(value={CountTimeAop.class})
public class WebMvcAutoConfiguration
implements WebMvcConfigurer,
InitializingBean {
    @Autowired
    private RedisRepository redisRepository;
    @Autowired
    private AsyncAutoConfiguration.AsyncThreadPoolTaskExecutor asyncThreadPoolTaskExecutor;
    @Autowired
    private InterceptorProperties interceptorProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(WebMvcAutoConfiguration.class, (String)"taotao-cloud-starter-web", (String[])new String[0]);
    }

    public void addCorsMappings(CorsRegistry registry) {
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        configurer.registerCallableInterceptors(new CallableProcessingInterceptor[]{new TimeoutCallableProcessingInterceptor()});
        configurer.registerDeferredResultInterceptors(new DeferredResultProcessingInterceptor[]{new TimeoutDeferredResultProcessingInterceptor()});
        configurer.setDefaultTimeout(1000L);
        configurer.setTaskExecutor((AsyncTaskExecutor)this.asyncThreadPoolTaskExecutor);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new LoginUserArgumentResolver());
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> handlers) {
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.interceptorProperties.getHeader().booleanValue()) {
            registry.addInterceptor((HandlerInterceptor)new HeaderThreadLocalInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/actuator/**"});
        }
        if (this.interceptorProperties.getDoubtApi().booleanValue()) {
            registry.addInterceptor((HandlerInterceptor)new DoubtApiInterceptor(this.interceptorProperties)).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/actuator/**"});
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        fastConverter.setFastJsonConfig(fastJsonConfig);
        converters.add((HttpMessageConverter<?>)fastConverter);
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter jackson2Converter = (MappingJackson2HttpMessageConverter)converter;
            jackson2Converter.setObjectMapper(JsonUtils.MAPPER);
        }
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory((ConverterFactory)new IntegerToEnumConverterFactory());
        registry.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
        registry.addConverter((Converter)new String2DateConverter());
        registry.addConverter((Converter)new String2LocalDateConverter());
        registry.addConverter((Converter)new String2LocalDateTimeConverter());
        registry.addConverter((Converter)new String2LocalTimeConverter());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/index").setViewName("index");
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        InternalResourceViewResolver internalResourceViewResolver = new InternalResourceViewResolver();
        internalResourceViewResolver.setPrefix("/WEB-INF/jsp/");
        internalResourceViewResolver.setSuffix(".jsp");
        registry.viewResolver((ViewResolver)internalResourceViewResolver);
    }

    @Bean
    @LoadBalanced
    public OkHttpClient.Builder builder() {
        return new OkHttpClient.Builder();
    }

    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory();
        return validatorFactory.getValidator();
    }

    @Bean
    public RequestMappingScanListener requestMappingScanListener() {
        return new RequestMappingScanListener(this.redisRepository);
    }

    public static class LoginUserArgumentResolver
    implements HandlerMethodArgumentResolver {
        public boolean supportsParameter(MethodParameter parameter) {
            boolean isHasEnableUserAnn = parameter.hasParameterAnnotation(LoginUser.class);
            boolean isHasLoginUserParameter = parameter.getParameterType().isAssignableFrom(SecurityUser.class);
            return isHasEnableUserAnn && isHasLoginUserParameter;
        }

        public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
            LoginUser user = (LoginUser)methodParameter.getParameterAnnotation(LoginUser.class);
            boolean value = user.value();
            HttpServletRequest request = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
            SecurityUser loginUser = SecurityUtils.getCurrentUser();
            return loginUser;
        }
    }
}

