/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.exception.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.web.exception.enums.ExceptionHandleTypeEnum;
import com.taotao.cloud.web.exception.handler.ExceptionHandler;
import com.taotao.cloud.web.exception.handler.LoggerExceptionHandler;
import com.taotao.cloud.web.exception.properties.ExceptionHandleProperties;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.web.global-exception", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LoggerExceptionHandlerAutoConfiguration
implements InitializingBean {
    @Autowired
    private ExceptionHandleProperties exceptionHandleProperties;
    @Autowired
    @Qualifier(value="requestMappingHandlerMapping")
    private RequestMappingHandlerMapping mapping;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(LoggerExceptionHandlerAutoConfiguration.class, (String)"taotao-cloud-starter-web", (String[])new String[0]);
    }

    @Bean
    public ExceptionHandler dingTalkGlobalExceptionHandler() {
        if (Arrays.stream(this.exceptionHandleProperties.getTypes()).anyMatch(e -> e.name().equals(ExceptionHandleTypeEnum.LOGGER.name()))) {
            return new LoggerExceptionHandler(this.mapping);
        }
        return null;
    }
}

