/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.exception.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.web.exception.enums.ExceptionHandleTypeEnum;
import com.taotao.cloud.web.exception.handler.ExceptionHandler;
import com.taotao.cloud.web.exception.handler.MailExceptionHandler;
import com.taotao.cloud.web.exception.properties.ExceptionHandleProperties;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.mail.javamail.JavaMailSender;

@AutoConfiguration
@ConditionalOnClass(value={JavaMailSender.class})
@ConditionalOnBean(value={JavaMailSender.class, MailProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.web.global-exception", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MailExceptionHandlerAutoConfiguration
implements InitializingBean {
    @Autowired
    private ExceptionHandleProperties exceptionHandleProperties;
    @Autowired
    private MailProperties mailProperties;
    @Value(value="${spring.application.name: unknown-application}")
    private String applicationName;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MailExceptionHandlerAutoConfiguration.class, (String)"taotao-cloud-starter-mail", (String[])new String[0]);
    }

    @Bean
    public ExceptionHandler mailGlobalExceptionHandler(JavaMailSender mailSender) {
        if (Arrays.stream(this.exceptionHandleProperties.getTypes()).anyMatch(e -> e.name().equals(ExceptionHandleTypeEnum.MAIL.name()))) {
            return new MailExceptionHandler(this.mailProperties, this.exceptionHandleProperties, mailSender, this.applicationName);
        }
        return null;
    }
}

