/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.exception.resolver;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.taotao.cloud.common.context.TraceContextHolder;
import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.exception.FeignErrorException;
import com.taotao.cloud.common.exception.IdempotencyException;
import com.taotao.cloud.common.exception.LockException;
import com.taotao.cloud.common.exception.MessageException;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.TraceUtils;
import com.taotao.cloud.core.configuration.AsyncAutoConfiguration;
import com.taotao.cloud.idempotent.exception.IdempotentException;
import com.taotao.cloud.limit.ext.LimitException;
import com.taotao.cloud.limit.ratelimiter.RateLimitException;
import com.taotao.cloud.web.annotation.BusinessApi;
import feign.codec.DecodeException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@AutoConfiguration
@RestControllerAdvice(annotations={BusinessApi.class})
public class BusinessHandlerExceptionAdvice
implements InitializingBean {
    private final List<com.taotao.cloud.web.exception.handler.ExceptionHandler> exceptionHandler;
    @Value(value="${spring.profiles.active:prod}")
    private String profile;
    @Autowired
    private AsyncAutoConfiguration.AsyncThreadPoolTaskExecutor asyncThreadPoolTaskExecutor;
    public static final String PROD_ERR_MSG = "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    public static final String NLP_MSG = "\u7a7a\u6307\u9488\u5f02\u5e38!";

    public BusinessHandlerExceptionAdvice(List<com.taotao.cloud.web.exception.handler.ExceptionHandler> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(BusinessHandlerExceptionAdvice.class, (String)"taotao-cloud-starter-web", (String[])new String[0]);
    }

    @ExceptionHandler(value={BaseException.class})
    public Result<String> baseException(NativeWebRequest req, BaseException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)e.getMessage(), (int)e.getCode());
    }

    @ExceptionHandler(value={FeignErrorException.class})
    public Result<String> feignException(NativeWebRequest req, FeignErrorException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.INNER_ERROR);
    }

    @ExceptionHandler(value={LockException.class})
    public Result<String> lockException(NativeWebRequest req, LockException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={IdempotencyException.class})
    public Result<String> idempotencyException(NativeWebRequest req, IdempotencyException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={BusinessException.class})
    public Result<String> businessException(NativeWebRequest req, BusinessException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)e.getMessage(), (int)e.getCode());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Result<String> illegalArgumentException(NativeWebRequest req, IllegalArgumentException e) {
        this.handleExceptions(req, e);
        return Result.fail((ResultEnum)ResultEnum.ILLEGAL_ARGUMENT_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public Result<String> badMethodExpressException(NativeWebRequest req, AccessDeniedException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.FORBIDDEN);
    }

    @ExceptionHandler(value={MessageException.class})
    public Result<String> badMessageException(NativeWebRequest req, MessageException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.MESSAGE_SEND_ERROR);
    }

    @ExceptionHandler(value={UsernameNotFoundException.class})
    public Result<String> badUsernameNotFoundException(NativeWebRequest req, UsernameNotFoundException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.USERNAME_OR_PASSWORD_ERROR);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<String> handleHttpRequestMethodNotSupportedException(NativeWebRequest req, HttpRequestMethodNotSupportedException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.METHOD_NOT_SUPPORTED_ERROR);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Result<String> handleHttpMediaTypeNotSupportedException(NativeWebRequest req, HttpMediaTypeNotSupportedException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.MEDIA_TYPE_NOT_SUPPORTED_ERROR);
    }

    @ExceptionHandler(value={SQLException.class})
    public Result<String> handleSqlException(NativeWebRequest req, SQLException e) {
        this.handleExceptions(req, e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class})
    public Result<String> handleSqlException(NativeWebRequest req, SQLIntegrityConstraintViolationException e) {
        this.handleExceptions(req, e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={PersistenceException.class})
    public Result<String> handleSqlException(NativeWebRequest req, PersistenceException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public Result<String> handleDataIntegrityViolationException(NativeWebRequest req, DataIntegrityViolationException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={DecodeException.class})
    public Result<String> handleDecodeException(NativeWebRequest req, DecodeException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={BindException.class})
    public Result<Map<String, String>> handleBindException(NativeWebRequest req, BindException e) {
        this.handleExceptions(req, (Exception)e);
        BindingResult bindingResult = e.getBindingResult();
        return Result.fail((String)this.getErrors(bindingResult));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<Map<String, String>> handleMethodArgumentNotValidException(NativeWebRequest req, MethodArgumentNotValidException e) {
        this.handleExceptions(req, (Exception)e);
        BindingResult bindingResult = e.getBindingResult();
        return Result.fail((String)this.getErrors(bindingResult));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Result<String> requestTypeMismatch(NativeWebRequest req, MethodArgumentTypeMismatchException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.METHOD_ARGUMENTS_TYPE_MISMATCH);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<String> requestMissingServletRequest(NativeWebRequest req, MissingServletRequestParameterException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.MISSING_SERVLET_REQUEST_PARAMETER);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<String> httpMessageNotReadableException(NativeWebRequest req, HttpMessageNotReadableException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.HTTP_MESSAGE_NOT_READABLE);
    }

    @ExceptionHandler(value={ValidationException.class})
    public Result<String> handleException(NativeWebRequest req, ValidationException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((ResultEnum)ResultEnum.VERIFY_ARGUMENT_ERROR);
    }

    @ExceptionHandler(value={LimitException.class})
    public Result<String> limitException(NativeWebRequest req, LimitException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)e.getMessage(), (int)e.getCode());
    }

    @ExceptionHandler(value={IdempotentException.class})
    public Result<String> idempotentException(NativeWebRequest req, IdempotentException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)e.getMessage(), (int)e.getCode());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<Map<String, String>> handleException(NativeWebRequest req, ConstraintViolationException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)this.getErrors(e));
    }

    @ExceptionHandler(value={Exception.class})
    public Result<String> handleException(NativeWebRequest req, Exception e) {
        this.handleExceptions(req, e);
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={Error.class})
    public Result<String> handleThrowable(NativeWebRequest req, Error e) {
        this.handleExceptions(req, new Exception(e.getMessage()));
        return Result.fail((ResultEnum)ResultEnum.ERROR);
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    public Result<String> handleUndeclaredThrowableException(NativeWebRequest req, UndeclaredThrowableException ex) {
        this.handleExceptions(req, ex);
        Throwable e = ex.getCause();
        LogUtils.error((String)"WebmvcHandler sentinel \u964d\u7ea7 \u8d44\u6e90\u540d\u79f0", (Object[])new Object[0]);
        String errMsg = e.getMessage();
        if (e instanceof FlowException) {
            errMsg = "\u88ab\u9650\u6d41\u4e86";
        }
        if (e instanceof DegradeException) {
            errMsg = "\u670d\u52a1\u964d\u7ea7\u4e86";
        }
        if (e instanceof ParamFlowException) {
            errMsg = "\u670d\u52a1\u70ed\u70b9\u964d\u7ea7\u4e86";
        }
        if (e instanceof SystemBlockException) {
            errMsg = "\u7cfb\u7edf\u8fc7\u8f7d\u4fdd\u62a4";
        }
        if (e instanceof AuthorityException) {
            errMsg = "\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38";
        }
        return Result.fail((String)errMsg, (int)429);
    }

    @ExceptionHandler(value={BlockException.class})
    public Result<String> handleBlockException(NativeWebRequest req, BlockException e) {
        this.handleExceptions(req, (Exception)e);
        LogUtils.error((String)"WebmvcHandler sentinel \u964d\u7ea7 \u8d44\u6e90\u540d\u79f0{}", (Object[])new Object[]{e, e.getRule().getResource()});
        String errMsg = e.getMessage();
        if (e instanceof FlowException) {
            errMsg = "\u88ab\u9650\u6d41\u4e86";
        }
        if (e instanceof DegradeException) {
            errMsg = "\u670d\u52a1\u964d\u7ea7\u4e86";
        }
        if (e instanceof ParamFlowException) {
            errMsg = "\u670d\u52a1\u70ed\u70b9\u964d\u7ea7\u4e86";
        }
        if (e instanceof SystemBlockException) {
            errMsg = "\u7cfb\u7edf\u8fc7\u8f7d\u4fdd\u62a4";
        }
        if (e instanceof AuthorityException) {
            errMsg = "\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38";
        }
        return Result.fail((String)errMsg, (int)429);
    }

    @ExceptionHandler(value={FlowException.class})
    public Result<String> handleFlowException(NativeWebRequest req, FlowException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)"\u88ab\u9650\u6d41\u4e86", (int)429);
    }

    @ExceptionHandler(value={DegradeException.class})
    public Result<String> handleDegradeException(NativeWebRequest req, DegradeException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)"\u670d\u52a1\u964d\u7ea7\u4e86", (int)429);
    }

    @ExceptionHandler(value={ParamFlowException.class})
    public Result<String> handleParamFlowException(NativeWebRequest req, ParamFlowException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)"\u670d\u52a1\u70ed\u70b9\u964d\u7ea7\u4e86", (int)429);
    }

    @ExceptionHandler(value={SystemBlockException.class})
    public Result<String> handleSystemBlockException(NativeWebRequest req, SystemBlockException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)"\u7cfb\u7edf\u8fc7\u8f7d\u4fdd\u62a4", (int)429);
    }

    @ExceptionHandler(value={AuthorityException.class})
    public Result<String> handleAuthorityException(NativeWebRequest req, AuthorityException e) {
        this.handleExceptions(req, (Exception)e);
        return Result.fail((String)"\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38", (int)429);
    }

    @ExceptionHandler(value={RateLimitException.class})
    public Result<String> rateLimitException(RateLimitException e) {
        return Result.fail((String)"\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38", (int)429);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result<String> handleDuplicateKeyException(DuplicateKeyException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        LogUtils.error((String)"\u8bf7\u6c42\u5730\u5740'{}',\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8bb0\u5f55'{}'", (Object[])new Object[]{requestURI, e.getMessage()});
        return Result.fail((String)"\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
    }

    @ExceptionHandler(value={MyBatisSystemException.class})
    public Result<String> handleCannotFindDataSourceException(MyBatisSystemException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String message = e.getMessage();
        if (message.contains("CannotFindDataSourceException")) {
            LogUtils.error((String)"\u8bf7\u6c42\u5730\u5740'{}', \u672a\u627e\u5230\u6570\u636e\u6e90", (Object[])new Object[]{requestURI});
            return Result.fail((String)"\u672a\u627e\u5230\u6570\u636e\u6e90\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        LogUtils.error((String)"\u8bf7\u6c42\u5730\u5740'{}', Mybatis\u7cfb\u7edf\u5f02\u5e38", (Object[])new Object[]{requestURI, e});
        return Result.fail((String)message);
    }

    private String getErrors(BindingResult result) {
        String errorMsg = "\u7cfb\u7edf\u5f02\u5e38";
        HashMap<String, String> map = new HashMap<String, String>();
        List list = result.getFieldErrors();
        for (FieldError error : list) {
            map.put(error.getField(), error.getDefaultMessage());
            errorMsg = error.getDefaultMessage();
        }
        return errorMsg;
    }

    private String getErrors(ConstraintViolationException e) {
        String errorMsg = "\u7cfb\u7edf\u5f02\u5e38";
        HashMap<String, String> map = new HashMap<String, String>();
        Set constraintViolations = e.getConstraintViolations();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            String property = constraintViolation.getPropertyPath().toString();
            String message = constraintViolation.getMessage();
            map.put(property, message);
            errorMsg = message;
        }
        return errorMsg;
    }

    public void handleExceptions(NativeWebRequest req, Exception e) {
        String traceId = TraceContextHolder.getTraceId();
        if (traceId == null) {
            traceId = TraceUtils.getTraceId();
        }
        if (traceId == null) {
            traceId = IdGeneratorUtils.getIdStr();
        }
        String finalTraceId = traceId;
        this.asyncThreadPoolTaskExecutor.submit(() -> this.exceptionHandler.forEach(handler -> handler.handle(req, e, finalTraceId)));
    }
}

