/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.exception.resolver;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.taotao.cloud.common.context.TraceContextHolder;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.TraceUtils;
import com.taotao.cloud.core.configuration.AsyncAutoConfiguration;
import com.taotao.cloud.feign.annotation.FeignApi;
import com.taotao.cloud.feign.model.FeignExceptionResult;
import com.taotao.cloud.web.exception.handler.ExceptionHandler;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.NestedServletException;

@AutoConfiguration
@Order(value=-2147483648)
@RestControllerAdvice(annotations={FeignApi.class})
public class FeignHandlerExceptionAdvice
implements InitializingBean {
    private final List<ExceptionHandler> exceptionHandler;
    @Value(value="${spring.profiles.active:prod}")
    private String profile;
    @Autowired
    private AsyncAutoConfiguration.AsyncThreadPoolTaskExecutor asyncThreadPoolTaskExecutor;
    public static final String PROD_ERR_MSG = "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    public static final String NLP_MSG = "\u7a7a\u6307\u9488\u5f02\u5e38!";

    public FeignHandlerExceptionAdvice(List<ExceptionHandler> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(FeignHandlerExceptionAdvice.class, (String)"taotao-cloud-starter-web", (String[])new String[0]);
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleBusinessException(NativeWebRequest req, BusinessException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult(e.getMessage()));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={NestedServletException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleNestedServletException(NativeWebRequest req, NestedServletException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult(e.getMessage()));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleException(NativeWebRequest req, Exception e) {
        this.handleExceptions(req, e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult(e.getMessage()));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={UndeclaredThrowableException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleUndeclaredThrowableException(NativeWebRequest req, UndeclaredThrowableException ex) {
        this.handleExceptions(req, ex);
        Throwable e = ex.getCause();
        LogUtils.error((String)"WebmvcHandler sentinel \u964d\u7ea7 \u8d44\u6e90\u540d\u79f0", (Object[])new Object[0]);
        String errMsg = e.getMessage();
        if (e instanceof FlowException) {
            errMsg = "\u88ab\u9650\u6d41\u4e86";
        }
        if (e instanceof DegradeException) {
            errMsg = "\u670d\u52a1\u964d\u7ea7\u4e86";
        }
        if (e instanceof ParamFlowException) {
            errMsg = "\u670d\u52a1\u70ed\u70b9\u964d\u7ea7\u4e86";
        }
        if (e instanceof SystemBlockException) {
            errMsg = "\u7cfb\u7edf\u8fc7\u8f7d\u4fdd\u62a4";
        }
        if (e instanceof AuthorityException) {
            errMsg = "\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38";
        }
        return JsonUtils.toJSONString((Object)new FeignExceptionResult(errMsg));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={BlockException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleBlockException(NativeWebRequest req, BlockException e) {
        this.handleExceptions(req, (Exception)e);
        LogUtils.error((String)"WebmvcHandler sentinel \u964d\u7ea7 \u8d44\u6e90\u540d\u79f0{}", (Object[])new Object[]{e, e.getRule().getResource()});
        String errMsg = e.getMessage();
        if (e instanceof FlowException) {
            errMsg = "\u88ab\u9650\u6d41\u4e86";
        }
        if (e instanceof DegradeException) {
            errMsg = "\u670d\u52a1\u964d\u7ea7\u4e86";
        }
        if (e instanceof ParamFlowException) {
            errMsg = "\u670d\u52a1\u70ed\u70b9\u964d\u7ea7\u4e86";
        }
        if (e instanceof SystemBlockException) {
            errMsg = "\u7cfb\u7edf\u8fc7\u8f7d\u4fdd\u62a4";
        }
        if (e instanceof AuthorityException) {
            errMsg = "\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38";
        }
        return JsonUtils.toJSONString((Object)new FeignExceptionResult(errMsg));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={FlowException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleFlowException(NativeWebRequest req, FlowException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult("\u88ab\u9650\u6d41\u4e86"));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={DegradeException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleDegradeException(NativeWebRequest req, DegradeException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult("\u670d\u52a1\u964d\u7ea7\u4e86"));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={ParamFlowException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleParamFlowException(NativeWebRequest req, ParamFlowException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult("\u670d\u52a1\u70ed\u70b9\u964d\u7ea7\u4e86"));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={SystemBlockException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleSystemBlockException(NativeWebRequest req, SystemBlockException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult("\u7cfb\u7edf\u8fc7\u8f7d\u4fdd\u62a4"));
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={AuthorityException.class})
    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    public String handleAuthorityException(NativeWebRequest req, AuthorityException e) {
        this.handleExceptions(req, (Exception)e);
        return JsonUtils.toJSONString((Object)new FeignExceptionResult("\u9650\u6d41\u6743\u9650\u63a7\u5236\u5f02\u5e38"));
    }

    public void handleExceptions(NativeWebRequest req, Exception e) {
        String traceId = TraceContextHolder.getTraceId();
        if (traceId == null) {
            traceId = TraceUtils.getTraceId();
        }
        if (traceId == null) {
            traceId = IdGeneratorUtils.getIdStr();
        }
        String finalTraceId = traceId;
        this.asyncThreadPoolTaskExecutor.submit(() -> this.exceptionHandler.forEach(handler -> handler.handle(req, e, finalTraceId)));
    }
}

