/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.interceptor;

import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.core.model.Collector;
import com.taotao.cloud.web.properties.InterceptorProperties;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class DoubtApiInterceptor
implements HandlerInterceptor {
    private final ThreadLocal<Long> beforeMem = new ThreadLocal();
    private final Map<String, DoubtApiInfo> statisticMap = new ConcurrentHashMap<String, DoubtApiInfo>();
    private final InterceptorProperties properties;

    public DoubtApiInterceptor(InterceptorProperties properties) {
        this.properties = properties;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        this.beforeMem.set(this.getJVMUsed());
        return true;
    }

    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) throws Exception {
        Long data = this.beforeMem.get();
        this.beforeMem.remove();
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            String methodPath = method.getBean().getClass().getName() + "." + method.getMethod().getName();
            String url = request.getRequestURI();
            long incrMem = this.getJVMUsed() - data;
            if (incrMem > (long)this.properties.getDoubtApiThreshold()) {
                if (this.statisticMap.containsKey(methodPath)) {
                    staticInfo = this.statisticMap.get(methodPath);
                    staticInfo.uri = url;
                    ++staticInfo.count;
                    staticInfo.totalIncreMem += incrMem;
                    if (staticInfo.totalIncreMem <= 0L) {
                        staticInfo.totalIncreMem = incrMem;
                        staticInfo.count = 1;
                    }
                } else {
                    staticInfo = new DoubtApiInfo();
                    staticInfo.method = methodPath;
                    staticInfo.uri = url;
                    staticInfo.count = 0;
                    staticInfo.totalIncreMem = 0L;
                    this.statisticMap.put(methodPath, staticInfo);
                }
                Collector collector = (Collector)ContextUtils.getBean(Collector.class, (boolean)true);
                if (Objects.nonNull(collector)) {
                    collector.value("taotao.cloud.monitor.doubtapi.info").set(this.statisticMap);
                }
            }
        }
    }

    private long getJVMUsed() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static class DoubtApiInfo
    implements Comparable<DoubtApiInfo> {
        private String uri;
        private String method;
        private long totalIncreMem;
        private int count;

        public DoubtApiInfo() {
        }

        public DoubtApiInfo(String uri, String method, long totalIncreMem, int count) {
            this.uri = uri;
            this.method = method;
            this.totalIncreMem = totalIncreMem;
            this.count = count;
        }

        @Override
        public int compareTo(DoubtApiInfo doubtApiInfo) {
            long cha;
            if (doubtApiInfo == null) {
                return -1;
            }
            long l = doubtApiInfo.count > 0 ? doubtApiInfo.totalIncreMem / (long)doubtApiInfo.count : (cha = doubtApiInfo.totalIncreMem - (long)this.count > 0L ? this.totalIncreMem / (long)this.count : this.totalIncreMem);
            if (cha > 0L) {
                return 1;
            }
            if (cha < 0L) {
                return -1;
            }
            return 0;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public long getTotalIncreMem() {
            return this.totalIncreMem;
        }

        public void setTotalIncreMem(long totalIncreMem) {
            this.totalIncreMem = totalIncreMem;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

