/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.request.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.logger.enums.RequestLoggerTypeEnum;
import com.taotao.cloud.web.request.properties.RequestLoggerProperties;
import com.taotao.cloud.web.request.service.IRequestLoggerService;
import com.taotao.cloud.web.request.service.impl.KafkaRequestLoggerServiceImpl;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.KafkaTemplate;

@AutoConfiguration
@ConditionalOnClass(value={KafkaTemplate.class})
@ConditionalOnBean(value={KafkaTemplate.class})
public class KafkaRequestLoggerConfiguration
implements InitializingBean {
    @Autowired
    private RequestLoggerProperties requestLoggerProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(KafkaRequestLoggerConfiguration.class, (String)"taotao-cloud-starter-logger", (String[])new String[0]);
    }

    @Bean
    public IRequestLoggerService kafkaRequestLoggerServiceImpl(KafkaTemplate<String, String> kafkaTemplate) {
        if (Arrays.stream(this.requestLoggerProperties.getTypes()).anyMatch(e -> e.name().equals(RequestLoggerTypeEnum.KAFKA.name()))) {
            return new KafkaRequestLoggerServiceImpl(kafkaTemplate);
        }
        return null;
    }
}

