/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.request.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.logger.enums.RequestLoggerTypeEnum;
import com.taotao.cloud.web.request.properties.RequestLoggerProperties;
import com.taotao.cloud.web.request.service.IRequestLoggerService;
import com.taotao.cloud.web.request.service.impl.LoggerRequestLoggerServiceImpl;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class LoggerRequestLoggerConfiguration
implements InitializingBean {
    @Autowired
    private RequestLoggerProperties requestLoggerProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(LoggerRequestLoggerConfiguration.class, (String)"taotao-cloud-starter-logger", (String[])new String[0]);
    }

    @Bean
    public IRequestLoggerService loggerRequestLoggerService() {
        if (Arrays.stream(this.requestLoggerProperties.getTypes()).anyMatch(e -> e.name().equals(RequestLoggerTypeEnum.LOGGER.name()))) {
            return new LoggerRequestLoggerServiceImpl();
        }
        return null;
    }
}

