/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.request.configuration;

import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.logger.enums.RequestLoggerTypeEnum;
import com.taotao.cloud.web.request.properties.RequestLoggerProperties;
import com.taotao.cloud.web.request.service.IRequestLoggerService;
import com.taotao.cloud.web.request.service.impl.RedisRequestLoggerServiceImpl;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={RedisRepository.class})
@ConditionalOnBean(value={RedisRepository.class})
public class RedisRequestLoggerConfiguration
implements InitializingBean {
    @Autowired
    private RequestLoggerProperties requestLoggerProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RedisRequestLoggerConfiguration.class, (String)"taotao-cloud-starter-cache-redis", (String[])new String[0]);
    }

    @Bean
    public IRequestLoggerService redisRequestLoggerService(RedisRepository redisRepository) {
        if (Arrays.stream(this.requestLoggerProperties.getTypes()).anyMatch(e -> e.name().equals(RequestLoggerTypeEnum.REDIS.name()))) {
            return new RedisRequestLoggerServiceImpl(redisRepository);
        }
        return null;
    }
}

