/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.request.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.web.request.aspect.RequestLoggerAspect;
import com.taotao.cloud.web.request.configuration.KafkaRequestLoggerConfiguration;
import com.taotao.cloud.web.request.configuration.LoggerRequestLoggerConfiguration;
import com.taotao.cloud.web.request.configuration.RedisRequestLoggerConfiguration;
import com.taotao.cloud.web.request.listener.RequestLoggerListener;
import com.taotao.cloud.web.request.properties.RequestLoggerProperties;
import com.taotao.cloud.web.request.service.IRequestLoggerService;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RedisRequestLoggerConfiguration.class, KafkaRequestLoggerConfiguration.class, LoggerRequestLoggerConfiguration.class})
@EnableConfigurationProperties(value={RequestLoggerProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.web.request", name={"enabled"}, havingValue="true")
public class RequestLoggerConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RequestLoggerConfiguration.class, (String)"taotao-cloud-starter-logger", (String[])new String[0]);
    }

    @Bean
    public RequestLoggerListener requestLoggerListener(List<IRequestLoggerService> requestLoggerServices) {
        return new RequestLoggerListener(requestLoggerServices);
    }

    @Bean
    public RequestLoggerAspect requestLoggerAspect() {
        return new RequestLoggerAspect();
    }
}

