/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.servlet.filter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.taotao.cloud.common.context.TenantContextHolder;
import com.taotao.cloud.common.utils.servlet.RequestUtils;
import com.taotao.cloud.common.utils.servlet.TraceUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

@WebFilter(filterName="TenantFilter", urlPatterns={"/*"}, asyncSupported=true)
public class TenantFilter
extends OncePerRequestFilter {
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return RequestUtils.excludeActuator((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            String tenantId = request.getParameter("taotao-cloud-tenant-id");
            if (StrUtil.isEmpty((CharSequence)tenantId)) {
                tenantId = request.getHeader("taotao-cloud-tenant-header");
            }
            if (StringUtil.isNotBlank((String)tenantId)) {
                TenantContextHolder.setTenant((String)tenantId);
                TraceUtils.mdcTenantId((String)tenantId);
            } else if (StringUtil.isBlank((String)TenantContextHolder.getTenant())) {
                TenantContextHolder.setTenant((String)"1");
                TraceUtils.mdcTenantId((String)"1");
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            TenantContextHolder.clear();
            TraceUtils.mdcRemoveTenantId();
        }
    }
}

